/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.filter;

import com.nuix.automate.dropwizard.utils.filter.RestApiUsageBatch;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.AutomateModule;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class AccessLogDataProcessor {
    private final int batchSize;
    final Map<String, AtomicInteger> requestCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final AtomicInteger batchCount = new AtomicInteger(0);
    private final Date batchStartTime = new Date();
    private final ExecutorService persistExecutorService = Executors.newSingleThreadExecutor();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final AtomicLong lastCommitTime = new AtomicLong(System.currentTimeMillis());
    private final long maxBatchTimeMillis;
    private final Consumer<RestApiUsageBatch> persistenceConsumer;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AccessLogDataProcessor.class);

    public AccessLogDataProcessor(int batchSize, long maxBatchTimeMillis, Consumer<RestApiUsageBatch> persistenceConsumer) {
        this.batchSize = batchSize;
        this.maxBatchTimeMillis = maxBatchTimeMillis;
        this.persistenceConsumer = persistenceConsumer;
        this.scheduler.scheduleAtFixedRate(this::checkElapsedTimeAndPersist, maxBatchTimeMillis, maxBatchTimeMillis, TimeUnit.MILLISECONDS);
    }

    private synchronized void persistIfNeeded() {
        if (this.batchCount.get() > 0) {
            ConcurrentHashMap<String, AtomicInteger> mapToPersist = new ConcurrentHashMap<String, AtomicInteger>(this.requestCountMap);
            this.persistExecutorService.submit(() -> this.persistenceConsumer.accept(new RestApiUsageBatch(this.batchStartTime.getTime(), Instant.now().getEpochSecond(), mapToPersist)));
            this.batchCount.set(0);
            this.lastCommitTime.set(System.currentTimeMillis());
            this.batchStartTime.setTime(Instant.now().toEpochMilli());
            this.requestCountMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkElapsedTimeAndPersist() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCommitTime.get() >= this.maxBatchTimeMillis) {
            AccessLogDataProcessor accessLogDataProcessor = this;
            synchronized (accessLogDataProcessor) {
                this.persistIfNeeded();
            }
        }
    }

    public void onDataReceived(String requestURI, String httpMethod) {
        this.onDataReceived(null, requestURI, httpMethod);
    }

    public void onDataReceived(AutomateModule origin, String requestURI, String httpMethod) {
        String key = (origin != null ? origin.getValue() + ":" : "") + httpMethod + " " + requestURI;
        this.requestCountMap.computeIfAbsent(key, k -> new AtomicInteger(0)).incrementAndGet();
        int currentBatchCount = this.batchCount.incrementAndGet();
        if (currentBatchCount >= this.batchSize) {
            this.persistIfNeeded();
        }
    }

    void persistDataBatch(RestApiUsageBatch batch) {
        this.persistenceConsumer.accept(batch);
    }

    public void flush() {
        this.scheduler.shutdown();
        if (!this.requestCountMap.isEmpty()) {
            LOGGER.info("Flushing " + this.requestCountMap.size() + " keys");
            this.persistDataBatch(new RestApiUsageBatch(this.batchStartTime.getTime(), Instant.now().getEpochSecond(), this.requestCountMap));
        }
        this.persistExecutorService.shutdown();
        try {
            if (!this.persistExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOGGER.info("Executor service did not terminate in the expected time.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("Executor service interrupted during shutdown.");
        }
    }
}

