/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.filter;

import com.nuix.automate.dropwizard.utils.filter.AccessLogDataProcessor;
import com.nuix.automate.dropwizard.utils.filter.UriListener;
import com.nuix.automate.utils.utilization.AutomateModule;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class RestApiUsageServletFilter
implements Filter {
    public static final String INTERNAL_REQUEST_HEADER = "X-Request-Module";
    private final AccessLogDataProcessor accessLogDataProcessor;
    private final Predicate<HttpServletRequest> authenticator;

    public RestApiUsageServletFilter(AccessLogDataProcessor accessLogDataProcessor, Predicate<HttpServletRequest> authenticator) {
        this.accessLogDataProcessor = accessLogDataProcessor;
        this.authenticator = authenticator;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            boolean authenticationHeaderPresent = httpServletRequest.getHeader("Authorization") != null;
            String uri = httpServletRequest.getRequestURI();
            String servletPath = Optional.ofNullable(httpServletRequest.getServletPath()).filter(path -> !"/".equals(path)).orElse("");
            String moduleName = httpServletRequest.getHeader(INTERNAL_REQUEST_HEADER);
            if (authenticationHeaderPresent && this.trackRequestBasedOnRequestModule(moduleName) && UriListener.getInstance().isValidRoute(uri.startsWith(servletPath) ? uri.substring(servletPath.length()) : uri, httpServletRequest.getMethod()) && this.authenticator.test(httpServletRequest)) {
                if (moduleName != null) {
                    this.accessLogDataProcessor.onDataReceived(AutomateModule.valueOfOrValue((String)moduleName), uri, httpServletRequest.getMethod());
                } else {
                    this.accessLogDataProcessor.onDataReceived(uri, httpServletRequest.getMethod());
                }
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean trackRequestBasedOnRequestModule(String moduleName) {
        if (moduleName == null) {
            return true;
        }
        return AutomateModule.AUTOMATE_ENGINE_SERVICE.getValue().equals(moduleName);
    }

    public void destroy() {
        this.accessLogDataProcessor.flush();
    }
}

