/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.filter;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class UriListener
implements ApplicationEventListener {
    private static final UriListener INSTANCE = new UriListener();
    private final List<RouteInfo> registeredRoutes = new ArrayList<RouteInfo>();

    private UriListener() {
    }

    public static UriListener getInstance() {
        return INSTANCE;
    }

    public void onEvent(ApplicationEvent event) {
        if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
            this.registeredRoutes.clear();
            ResourceModel resourceModel = event.getResourceModel();
            resourceModel.getResources().forEach(resource -> resource.getResourceMethods().forEach(method -> {
                RouteInfo routeInfo = new RouteInfo(resource.getPath(), method.getHttpMethod());
                this.registeredRoutes.add(routeInfo);
            }));
        }
    }

    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return null;
    }

    public boolean isValidRoute(String path, String httpMethod) {
        return this.registeredRoutes.stream().anyMatch(route -> route.matches(path, httpMethod));
    }

    public boolean addRoute(String path, String httpMethod) {
        RouteInfo newRoute = new RouteInfo(path, httpMethod);
        if (this.registeredRoutes.stream().noneMatch(route -> route.matches(path, httpMethod))) {
            this.registeredRoutes.add(newRoute);
            return true;
        }
        return false;
    }

    public static class RouteInfo {
        private final String path;
        private final String httpMethod;

        public RouteInfo(String path, String httpMethod) {
            this.path = path;
            this.httpMethod = httpMethod;
        }

        public boolean matches(String inputPath, String inputMethod) {
            String normalizedInputPath;
            String normalizedStoredPath = this.path.replaceAll("^/|/$", "");
            return normalizedStoredPath.equals(normalizedInputPath = inputPath.replaceAll("^/|/$", "")) && this.httpMethod.equalsIgnoreCase(inputMethod);
        }

        public String getPath() {
            return this.path;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String toString() {
            return "Route{path='" + this.path + "', method='" + this.httpMethod + "'}";
        }
    }
}

