/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.health;

import com.codahale.metrics.health.HealthCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;

public class TusEndpointHealthCheck
extends HealthCheck {
    private String tusUploadUrl;
    private HttpClient httpClient;

    public TusEndpointHealthCheck(String tusUploadUrl, HttpClient httpClient) {
        this.tusUploadUrl = tusUploadUrl;
        this.httpClient = httpClient;
    }

    protected HealthCheck.Result check() throws Exception {
        HttpOptions httpOptions = new HttpOptions(this.tusUploadUrl);
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpOptions);
        Header tusResumableHeader = httpResponse.getFirstHeader("Tus-Resumable");
        if (tusResumableHeader != null && StringUtils.equals((CharSequence)tusResumableHeader.getValue(), (CharSequence)"1.0.0")) {
            Header tusExtensionHeader = httpResponse.getFirstHeader("Tus-Extension");
            if (tusExtensionHeader != null && StringUtils.contains((CharSequence)tusExtensionHeader.getValue(), (CharSequence)"creation")) {
                return HealthCheck.Result.healthy();
            }
            return HealthCheck.Result.unhealthy((String)(this.tusUploadUrl + " returned invalid Tus-Extension header"));
        }
        return HealthCheck.Result.unhealthy((String)(this.tusUploadUrl + " returned invalid Tus-Resumable header"));
    }
}

