/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.models;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.general.MockUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class UserServiceClient {
    protected final Random random = new Random();

    public abstract void update(UserService var1) throws Exception;

    public abstract void close();

    public abstract boolean supportsPasswordAuthentication();

    public abstract List<UserAccount> getUserAccounts(UserService var1, boolean var2) throws Exception;

    public abstract List<UserAccount> getUserAccounts(UserService var1, boolean var2, boolean var3) throws Exception;

    public abstract BearerUser authenticateUser(PasswordAuthenticationSubmission var1) throws Exception;

    protected List<UserAccount> buildMockUserAccounts(String userServiceId, UserAccountPlatform platform, int count, boolean changingValues) {
        ArrayList<UserAccount> mockUserAccounts = new ArrayList<UserAccount>();
        for (int i = 0; i < count; ++i) {
            UserAccount userAccount = new UserAccount();
            userAccount.setUserServiceId(userServiceId);
            userAccount.setUserAccountState(UserAccountState.ACTIVE);
            userAccount.setPlatform(platform);
            String name = "m" + MockUtils.getInstance().getName(i) + i + "@example.com";
            userAccount.setId(UidUtils.fromString((String)name));
            userAccount.setName(name);
            String email = "mock." + MockUtils.getInstance().getName(i) + "." + i + "@example.com";
            if (changingValues) {
                email = email + this.random.nextInt(5);
            }
            userAccount.setEmail(email);
            mockUserAccounts.add(userAccount);
        }
        return mockUserAccounts;
    }
}

