/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.resources;

import com.nuix.automate.utils.api.health.HealthInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/health")
@Produces(value={"application/json"})
public class HealthResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(HealthResource.class);
    private AutomateApplication automateApplication;
    private AutomateConfiguration automateConfiguration;

    public HealthResource(AutomateApplication automateApplication, AutomateConfiguration automateConfiguration) {
        this.automateApplication = automateApplication;
        this.automateConfiguration = automateConfiguration;
    }

    @GET
    @Consumes(value={"application/json"})
    public Response getHealthCheck() {
        HashMap<String, String> response = new HashMap<String, String>();
        HealthInfo healthInfo = this.automateApplication.getHealthInfo();
        if (healthInfo.getStatusType().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            response.put("status", "healthy");
        } else {
            response.put("status", "unhealthy");
        }
        response.put("message", healthInfo.getMessage());
        return Response.status((Response.StatusType)healthInfo.getStatusType()).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
    }
}

