/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/version")
public class VersionResources {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VersionResources.class);
    private AutomateApplication automateApplication;
    private AutomateConfiguration automateConfiguration;
    private static String version = null;
    private static String workflowVersion = null;

    public VersionResources(AutomateApplication automateApplication, AutomateConfiguration automateConfiguration) {
        this.automateApplication = automateApplication;
        this.automateConfiguration = automateConfiguration;
    }

    public static synchronized String getVersion() {
        return VersionResources.getVersion(VersionResources.class);
    }

    public static synchronized String getVersion(Class c) {
        if (version == null) {
            String commandLineVersion = System.getProperty("version");
            version = commandLineVersion != null ? commandLineVersion : c.getPackage().getImplementationVersion();
        }
        return version;
    }

    @Operation(tags={"Utils"}, operationId="GetAutomateVersion", summary="Get Automate Version", description="Returns the version of Automate", responses={@ApiResponse(description="Version", content={@Content(schema=@Schema(implementation=String.class, example="1.2.3-preview01"))})})
    @GET
    @Path(value="/automate")
    @Produces(value={"application/json"})
    @SecurityRequirement(name="Bearer_Token")
    public Response getAutomateVersion(@Parameter(hidden=true) @Auth BearerUser user) {
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)VersionResources.getVersion(AutomateApplication.class)).build();
    }

    @Operation(tags={"Utils"}, operationId="GetWorkflowVersion", summary="Get Workflow version", description="Returns the version of the Automate Workflow Engine", responses={@ApiResponse(description="Version", content={@Content(schema=@Schema(implementation=String.class, example="1.2.3-preview01"))})})
    @SecurityRequirement(name="Bearer_Token")
    @PermitAll
    @GET
    @Path(value="/workflow")
    @Produces(value={"application/json"})
    public Response getWorkflowVersion(@Parameter(hidden=true) @Auth BearerUser umsUser) {
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)VersionResources.getVersion(AutomateApplication.class)).build();
    }

    @Operation(tags={"Utils"}, operationId="GetJavaVersion", summary="Get Java version", description="Returns the version of the Java Virtual Machine", responses={@ApiResponse(description="Version", content={@Content(schema=@Schema(implementation=String.class, example="Eclipse Foundation 11.0.12+7 OpenJDK 64-Bit Server VM"))})})
    @SecurityRequirement(name="Bearer_Token")
    @PermitAll
    @GET
    @Path(value="/java")
    @Produces(value={"application/json"})
    public Response getJavaVersion(@Parameter(hidden=true) @Auth BearerUser umsUser) {
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.automateApplication.getJavaVersion()).build();
    }
}

