/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.dropwizard.utils.security.bearer;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;

public abstract class BearerUser
implements Principal {
    private String id;
    private String bearerToken;
    private String sessionId;
    private Identifier identifier;

    public abstract void invalidate();

    public abstract boolean refresh();

    public BearerUser(Identifier identifier) {
        this.identifier = identifier;
    }

    public Set<Identifier> getIdentifiers() {
        HashSet<Identifier> identifiers = new HashSet<Identifier>();
        if (this.identifier != null) {
            identifiers.add(this.identifier);
        }
        identifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.AUTHENTICATED_USER));
        return identifiers;
    }

    @Override
    public boolean equals(Object another) {
        try {
            return (BearerUser)another == this;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return this.identifier.toString();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public String getName() {
        return this.identifier.getIdentifierName();
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getShortSessionId() {
        if (this.sessionId == null) {
            return SecurityUtils.getRandomAlphaNumericString((int)5);
        }
        return FormattingUtils.getShortId((String)this.sessionId, (int)5);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }
}

