/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.nuix.automate.dropwizard.utils.filter.AccessLogDataProcessor;
import com.nuix.automate.dropwizard.utils.filter.RestApiUsageBatch;
import com.nuix.automate.dropwizard.utils.filter.RestApiUsageServletFilter;
import com.nuix.automate.dropwizard.utils.filter.UriListener;
import com.nuix.automate.dropwizard.utils.resources.ErrorResource;
import com.nuix.automate.dropwizard.utils.resources.HealthResource;
import com.nuix.automate.dropwizard.utils.resources.ServicesResource;
import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.server.persistance.ConfigurationDao;
import com.nuix.automate.server.resources.ConfigResource;
import com.nuix.automate.server.resources.ConsumptionResource;
import com.nuix.automate.server.resources.EnginesResource;
import com.nuix.automate.server.resources.JobFileResource;
import com.nuix.automate.server.resources.LogsResource;
import com.nuix.automate.server.resources.OperationMimeTypeStatsResource;
import com.nuix.automate.server.resources.ProcessingEventsResource;
import com.nuix.automate.server.resources.SessionResource;
import com.nuix.automate.server.resources.UserDataDirResource;
import com.nuix.automate.server.resources.UtilizationResource;
import com.nuix.automate.server.resources.WorkflowDynamicUpdatesResource;
import com.nuix.automate.server.security.bearer.BearerAuthenticator;
import com.nuix.automate.server.workers.EngineWorker;
import com.nuix.automate.server.workers.RegistrationWorker;
import com.nuix.automate.server.workers.ServerWorker;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.health.HealthInfo;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.configuration.ApiTrackingConfiguration;
import com.nuix.automate.utils.api.internal.configuration.CacheConfiguration;
import com.nuix.automate.utils.general.NameResolver;
import com.nuix.automate.utils.general.NetworkUtils;
import com.nuix.automate.utils.general.SystemResourcesUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.logging.CentralizedLogInterceptor;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.utilization.AutomateModule;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import com.nuix.automate.utils.utilization.consumption.ConsumptionPlatformType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionSubType;
import com.nuix.automate.utils.utilization.consumption.ConsumptionType;
import com.nuix.automate.utils.utilization.consumption.ResourceSubType;
import com.nuix.automate.utils.utilization.consumption.ResourceType;
import com.nuix.automate.utils.utilization.consumption.UnitType;
import io.dropwizard.Application;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.auth.AuthFilter;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.PolymorphicAuthDynamicFeature;
import io.dropwizard.auth.PolymorphicAuthValueFactoryProvider;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.auth.oauth.OAuthCredentialAuthFilter;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiFactory;
import io.dropwizard.logging.LoggingUtil;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.web.WebBundle;
import io.dropwizard.web.conf.WebConfiguration;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.StatementException;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ServerApplication
extends Application<ServerConfiguration>
implements AutomateApplication {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerApplication.class);
    private static ServerApplication instance;
    private ServerConfiguration configuration;
    private Environment environment;
    private ConfigurationDao engineServerConfigurationDao;
    private BearerAuthenticator bearerAuthenticator;
    private ConfigResource configResource;
    private EnginesResource serverEnginesResource;
    private LogsResource serverLogsResource;
    private UserDataDirResource userDataDirResource;
    private JobFileResource jobFileResource;
    private OperationMimeTypeStatsResource operationMimeTypeStatsResource;
    private ProcessingEventsResource processingEventsResource;
    private SessionResource sessionResource;
    private ConsumptionResource consumptionResource;
    private UtilizationResource serverUtilizationResource;
    private WorkflowDynamicUpdatesResource workflowDynamicUpdatesResource;
    private ServerWorker serverWorker;
    private RegistrationWorker registrationWorker;
    private Map<String, NuixLicenseSourceModel> serverNuixLicenceSources;
    private Map<String, ExecutionProfileModel> serverExecutionProfiles;
    private AutomateLicenceModel serverRampivaLicence;
    private final NetworkConfiguration serverNetworkConfiguration;
    private CentralizedLogInterceptor<ILoggingEvent> centralizedLoggingAppender;
    private LogHandler logHandler;
    private LicenceUtils licenceUtils;
    private String runId;
    private String instanceId;
    private String nuixVersion;
    private boolean initializing;
    private boolean closing;
    private int lastDayHeaderLogged;

    public ServerApplication() {
        instance = this;
        this.serverNetworkConfiguration = NetworkConfiguration.fromSystemProperties();
    }

    public static ServerApplication getInstance() {
        return instance;
    }

    public ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServerConfiguration serverConfiguration) {
        this.configuration = serverConfiguration;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    private void logHeader(boolean force) {
        if (force) {
            this.lastDayHeaderLogged = 0;
        }
        this.logHeader();
    }

    private void logHeader() {
        int currentDay = DateTime.now().getDayOfYear();
        if (currentDay != this.lastDayHeaderLogged) {
            this.lastDayHeaderLogged = currentDay;
            LOGGER.info("################### " + ((Object)((Object)this)).getClass().getSimpleName() + " ###################");
            LOGGER.info("DateTime UTC: " + DateTime.now((DateTimeZone)DateTimeZone.UTC));
            LOGGER.info("Automate Version: " + VersionResources.getVersion());
            LOGGER.info("JVM Version: " + System.getProperty("java.vendor") + " / " + System.getProperty("java.runtime.version") + " / " + System.getProperty("java.vm.name"));
            LOGGER.info("JVM Path: " + System.getProperty("java.home"));
            LOGGER.info("OS: " + System.getProperty("os.name") + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version"));
            LOGGER.info("PATH: " + System.getenv("PATH"));
            LOGGER.info("Role: " + this.configuration.getRole());
            try {
                NameResolver nameResolver = new NameResolver(this.configuration.getNameResolutionTimeout());
                LOGGER.info("IP addresses: " + String.join((CharSequence)",", nameResolver.getLocalIpAddresses()));
            }
            catch (Exception e) {
                LOGGER.info("IP addresses: Unknown");
            }
        }
    }

    public void setServerNuixLicenceSources(Map<String, NuixLicenseSourceModel> serverNuixLicenceSources) {
        this.serverNuixLicenceSources = serverNuixLicenceSources;
    }

    public void setServerRampivaLicence(AutomateLicenceModel serverRampivaLicence) {
        this.serverRampivaLicence = serverRampivaLicence;
    }

    public AutomateLicenceModel getServerRampivaLicence() {
        return this.serverRampivaLicence;
    }

    public NetworkConfiguration getServerNetworkConfiguration() {
        return this.serverNetworkConfiguration;
    }

    public Map<String, NuixLicenseSourceModel> getServerNuixLicenceSources() {
        return this.serverNuixLicenceSources;
    }

    public void setServerExecutionProfiles(Map<String, ExecutionProfileModel> serverExecutionProfiles) {
        this.serverExecutionProfiles = serverExecutionProfiles;
    }

    public Map<String, ExecutionProfileModel> getServerExecutionProfiles() {
        if (this.serverExecutionProfiles == null) {
            this.serverExecutionProfiles = new HashMap<String, ExecutionProfileModel>();
        }
        return this.serverExecutionProfiles;
    }

    public LicenceUtils getLicenceUtils() {
        return this.licenceUtils;
    }

    public static void main(String[] args) throws Exception {
        new ServerApplication().run(args);
    }

    public ConfigResource getConfigResource() {
        return this.configResource;
    }

    public ServerWorker getServerWorker() {
        return this.serverWorker;
    }

    public RegistrationWorker getRegistrationWorker() {
        return this.registrationWorker;
    }

    public EnginesResource getServerEnginesResource() {
        return this.serverEnginesResource;
    }

    public LogsResource getServerLogsResource() {
        return this.serverLogsResource;
    }

    public UserDataDirResource getUserDataDirResource() {
        return this.userDataDirResource;
    }

    public JobFileResource getJobFileResource() {
        return this.jobFileResource;
    }

    public OperationMimeTypeStatsResource getOperationMimeTypeStatsResource() {
        return this.operationMimeTypeStatsResource;
    }

    public ProcessingEventsResource getProcessingEventsResource() {
        return this.processingEventsResource;
    }

    public SessionResource getSessionResource() {
        return this.sessionResource;
    }

    public ConsumptionResource getConsumptionResource() {
        return this.consumptionResource;
    }

    public UtilizationResource getServerUtilizationResource() {
        return this.serverUtilizationResource;
    }

    public WorkflowDynamicUpdatesResource getWorkflowDynamicUpdatesResource() {
        return this.workflowDynamicUpdatesResource;
    }

    public String getName() {
        return "Automate Server";
    }

    public void initialize(Bootstrap<ServerConfiguration> bootstrap) {
        final String[] styleSrcHashes = new String[]{"'sha256-Pt+3ApmjQaR1IA87F/r0Px4hIo3skUP3AMdXS+P1bTA='", "'sha256-47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU='", "'sha256-MBVp6JYxbC/wICelYC6eULCRpgi9kGezXXSaq/TS2+I='"};
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/assets", "/", "index.html"));
        bootstrap.addBundle((ConfiguredBundle)new WebBundle<ServerConfiguration>(){

            public WebConfiguration getWebConfiguration(ServerConfiguration configuration) {
                WebConfiguration webConfiguration = configuration.getWebConfiguration();
                if (webConfiguration != null && webConfiguration.getCspHeaderFactory() != null) {
                    String csp = webConfiguration.getCspHeaderFactory().getPolicy();
                    CharSequence[] fields = csp.split(";");
                    int styleFieldIndex = -1;
                    for (int i = 0; i < fields.length; ++i) {
                        String fieldName = fields[i].trim().split(" ")[0];
                        if (!fieldName.trim().equalsIgnoreCase("style-src")) continue;
                        styleFieldIndex = i;
                        break;
                    }
                    if (styleFieldIndex >= 0) {
                        int n = styleFieldIndex;
                        fields[n] = (String)fields[n] + " " + String.join((CharSequence)" ", styleSrcHashes);
                    }
                    csp = String.join((CharSequence)";", fields);
                    webConfiguration.getCspHeaderFactory().setPolicy(csp);
                }
                return webConfiguration;
            }
        });
        bootstrap.getObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public BearerAuthenticator getBearerAuthenticator() {
        return this.bearerAuthenticator;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getJavaVersion() {
        return System.getProperty("java.vendor") + " " + System.getProperty("java.runtime.version");
    }

    private void applyConfigurationInit(ConfigurationDao applicationInitDao, ConfigurationDao applicationDao) {
        LOGGER.info("Applying engines init");
        List<EngineModel> enginesInit = applicationInitDao.getEngines();
        if (enginesInit.size() > 0) {
            LOGGER.info("Read " + enginesInit.size() + " records");
            for (EngineModel engineInit : enginesInit) {
                engineInit.setServerId(this.instanceId);
                try {
                    applicationDao.addEngine(engineInit);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot add init Engine " + engineInit.getId(), (Throwable)e);
                }
            }
        }
        try {
            this.engineServerConfigurationDao.getIds();
        }
        catch (StatementException e) {
            LOGGER.info("Creating new Configuration Store - Services ");
            this.engineServerConfigurationDao.createServicesTable();
        }
        try {
            this.engineServerConfigurationDao.addId(this.instanceId);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    private void updateConfigurationTables(ConfigurationDao engineServerConfigurationDao, boolean resetEnginesServerId) {
        try {
            engineServerConfigurationDao.updateEnginesTable1();
            LOGGER.info("Updated Engines table schema 1");
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            engineServerConfigurationDao.updateEnginesTable2();
            LOGGER.info("Updated Engines table schema 2");
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            engineServerConfigurationDao.updateEnginesTable3();
            LOGGER.info("Updated Engines table schema 3");
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            engineServerConfigurationDao.updateEnginesTable4();
            LOGGER.info("Updated Engines table schema 4");
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            engineServerConfigurationDao.updateEnginesTable5();
            if (resetEnginesServerId) {
                engineServerConfigurationDao.updateEnginesTable5SetServerId(this.instanceId);
            }
            LOGGER.info("Updated Engines table schema 5");
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    public void run(ServerConfiguration configuration, Environment environment) throws Exception {
        NetworkUtils.startDebugShutdownSocket();
        this.initializing = true;
        this.environment = environment;
        this.configuration = configuration;
        LOGGER.info("\n\n");
        LOGGER.info("######################### INIT #########################");
        this.logHeader();
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ServerApplication.this.logHeader();
            }
        }, 0L, 60000L);
        this.runId = UidUtils.getRandom();
        ErrorPageErrorHandler errorPageErrorHandler = new ErrorPageErrorHandler();
        errorPageErrorHandler.addErrorPage(404, "/api/error/404");
        environment.getApplicationContext().setErrorHandler((ErrorHandler)errorPageErrorHandler);
        try {
            block41: {
                CacheConfiguration cacheConfiguration = new CacheConfiguration();
                cacheConfiguration.setGlobalResponseCacheMaxValidity(configuration.getGlobalResponseCacheMaxValidity());
                cacheConfiguration.setResponseCacheMaxValidity(configuration.getResponseCacheMaxValidity());
                cacheConfiguration.setDisableResponseCache(configuration.getDisableResponseCache());
                ResponseCache.initialize((CacheConfiguration)cacheConfiguration);
                environment.jersey().property("jersey.config.server.contentLength.buffer", (Object)0);
                LoggerContext context = LoggingUtil.getLoggerContext();
                Logger logger = context.getLogger("ROOT");
                this.centralizedLoggingAppender = new CentralizedLogInterceptor();
                this.centralizedLoggingAppender.setName("centralized-logging");
                this.centralizedLoggingAppender.setContext((Context)context);
                this.centralizedLoggingAppender.start();
                if (configuration.getEnableCentralizedLogging()) {
                    logger.addAppender(this.centralizedLoggingAppender);
                }
                this.logHandler = LogHandler.getInstance();
                this.logHandler.configureInstance((AutomateApplication)this, (AutomateConfiguration)configuration);
                this.logHandler.updateLogHandlerComponent();
                if (configuration.getCorsAllowedOrigins() != null) {
                    LOGGER.info("Setting CORS configuration");
                    FilterRegistration.Dynamic cors = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
                    cors.setInitParameter("allowedOrigins", configuration.getCorsAllowedOrigins());
                    if (configuration.getCorsAllowedHeaders() != null) {
                        cors.setInitParameter("allowedHeaders", configuration.getCorsAllowedHeaders());
                    }
                    if (configuration.getCorsAllowedMethods() != null) {
                        cors.setInitParameter("allowedMethods", configuration.getCorsAllowedMethods());
                    }
                    cors.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
                    cors.setInitParameter("chainPreflight", Boolean.FALSE.toString());
                }
                SystemResourcesUtils.getInstance().checkMemoryUsage("Init");
                this.bearerAuthenticator = new BearerAuthenticator(this, configuration);
                UnauthorizedHandler unauthorizedHandler = new UnauthorizedHandler(){

                    @Nullable
                    public Response buildResponse(String prefix, String realm) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
                    }
                };
                AuthFilter oauthCredentialAuthFilter = new OAuthCredentialAuthFilter.Builder().setAuthenticator((Authenticator)this.bearerAuthenticator).setPrefix("Bearer").setUnauthorizedHandler(unauthorizedHandler).buildAuthFilter();
                PolymorphicAuthDynamicFeature feature = new PolymorphicAuthDynamicFeature((Map)ImmutableMap.of(BearerUser.class, (Object)oauthCredentialAuthFilter));
                PolymorphicAuthValueFactoryProvider.Binder binder = new PolymorphicAuthValueFactoryProvider.Binder((Set)ImmutableSet.of(BearerUser.class));
                environment.jersey().register((Object)feature);
                environment.jersey().register((Object)binder);
                environment.jersey().register(RolesAllowedDynamicFeature.class);
                if (configuration.getDebugLogRequestResponse()) {
                    LOGGER.info("Enabling verbose request/response logging");
                    environment.jersey().register((Object)new LoggingFeature(java.util.logging.Logger.getLogger("inbound"), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_ANY, Integer.valueOf(81920)));
                }
                this.licenceUtils = new LicenceUtils();
                environment.jersey().setUrlPattern("/api/*");
                environment.jersey().register((Object)new ErrorResource());
                configuration.initializeFromEnv();
                configuration.initApplicationStore();
                DataSourceFactory initStore = configuration.getEngineServerConfigurationStore();
                DataSourceFactory applicationStore = configuration.getApplicationStore();
                JdbiFactory factory = new JdbiFactory();
                ConfigurationDao initDao = null;
                LOGGER.info("Initializing Application store " + applicationStore.getUrl());
                Jdbi jdbiConfiguration = factory.build(environment, (PooledDataSourceFactory)applicationStore, "configurationStore");
                this.engineServerConfigurationDao = (ConfigurationDao)jdbiConfiguration.onDemand(ConfigurationDao.class);
                this.engineServerConfigurationDao.checkConnection();
                if (initStore != applicationStore) {
                    LOGGER.info("Initializing Application Init store " + initStore.getUrl());
                    Jdbi jdbiInit = factory.build(environment, (PooledDataSourceFactory)initStore, "configurationInitStore");
                    initDao = (ConfigurationDao)jdbiInit.onDemand(ConfigurationDao.class);
                    initDao.checkConnection();
                }
                if (configuration.getServerInstanceId() != null) {
                    this.instanceId = configuration.getServerInstanceId();
                    LOGGER.info("Using Server Instance ID " + this.instanceId + " from configuration");
                }
                if (this.instanceId == null) {
                    try {
                        this.instanceId = this.engineServerConfigurationDao.getIds().get(0);
                        LOGGER.info("Using Server Instance ID " + this.instanceId + " from application database");
                    }
                    catch (Exception jdbiInit) {
                        // empty catch block
                    }
                }
                if (this.instanceId == null && initDao != null) {
                    try {
                        this.instanceId = initDao.getIds().get(0);
                        LOGGER.info("Using Server Instance ID " + this.instanceId + " from init application database");
                    }
                    catch (Exception jdbiInit) {
                        // empty catch block
                    }
                }
                if (this.instanceId == null && initDao != null) {
                    try {
                        this.instanceId = initDao.getLegacyIds().get(0);
                        LOGGER.info("Using Server Instance ID " + this.instanceId + " from legacy init application database");
                    }
                    catch (Exception jdbiInit) {
                        // empty catch block
                    }
                }
                if (this.instanceId == null && initStore == applicationStore) {
                    try {
                        this.engineServerConfigurationDao.getIds();
                    }
                    catch (StatementException e) {
                        LOGGER.info("Creating new Configuration Store - Services ");
                        this.engineServerConfigurationDao.createServicesTable();
                    }
                    try {
                        this.engineServerConfigurationDao.addId(this.instanceId);
                    }
                    catch (StatementException e) {
                        // empty catch block
                    }
                }
                if (this.instanceId == null) {
                    try {
                        this.instanceId = this.engineServerConfigurationDao.getLegacyIds().get(0);
                        LOGGER.info("Migrating Server Instance ID " + this.instanceId + " from legacy application database");
                        try {
                            this.engineServerConfigurationDao.addId(this.instanceId);
                        }
                        catch (StatementException e) {}
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.instanceId == null) {
                    this.instanceId = UidUtils.getRandom();
                    LOGGER.info("Initialized new Server Instance ID " + this.instanceId);
                    if (initStore == applicationStore) {
                        try {
                            this.engineServerConfigurationDao.addId(this.instanceId);
                        }
                        catch (StatementException e) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.engineServerConfigurationDao.getEngineIds();
                    boolean resetEnginesServerIds = initStore == applicationStore;
                    this.updateConfigurationTables(this.engineServerConfigurationDao, resetEnginesServerIds);
                }
                catch (StatementException e) {
                    LOGGER.info("Creating new Configuration Store - Engines ");
                    try {
                        this.engineServerConfigurationDao.createEnginesTableMssql();
                    }
                    catch (Exception ex) {
                        this.engineServerConfigurationDao.createEnginesTableSqlite();
                    }
                    if (initStore == applicationStore) break block41;
                    this.updateConfigurationTables(initDao, false);
                    this.applyConfigurationInit(initDao, this.engineServerConfigurationDao);
                }
            }
            this.logHandler.setComponentId(this.instanceId);
            try {
                this.serverWorker = new ServerWorker(this);
            }
            catch (AlreadyBoundException | RemoteException e) {
                LOGGER.error("Cannot initialize Server", (Throwable)e);
                throw e;
            }
            this.configResource = new ConfigResource(this);
            environment.jersey().register((Object)this.configResource);
            this.serverEnginesResource = new EnginesResource(this, configuration);
            this.serverEnginesResource.addEnginesFromStore();
            environment.jersey().register((Object)this.serverEnginesResource);
            this.serverUtilizationResource = new UtilizationResource(this);
            environment.jersey().register((Object)this.serverUtilizationResource);
            this.processingEventsResource = new ProcessingEventsResource(this);
            environment.jersey().register((Object)this.processingEventsResource);
            this.workflowDynamicUpdatesResource = new WorkflowDynamicUpdatesResource(this);
            environment.jersey().register((Object)this.workflowDynamicUpdatesResource);
            this.operationMimeTypeStatsResource = new OperationMimeTypeStatsResource(this);
            environment.jersey().register((Object)this.operationMimeTypeStatsResource);
            this.serverLogsResource = new LogsResource(this);
            environment.jersey().register((Object)this.serverLogsResource);
            this.userDataDirResource = new UserDataDirResource();
            environment.jersey().register((Object)this.userDataDirResource);
            this.jobFileResource = new JobFileResource(configuration.getJobFilesDirectory());
            environment.jersey().register((Object)this.jobFileResource);
            this.sessionResource = new SessionResource(this);
            environment.jersey().register((Object)this.sessionResource);
            this.consumptionResource = new ConsumptionResource(this);
            environment.jersey().register((Object)this.consumptionResource);
            environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(BearerUser.class));
            if (!configuration.getDisableBusinessEndpoints()) {
                environment.jersey().register((Object)new ServicesResource((AutomateApplication)this, (AutomateConfiguration)configuration));
            }
            if (!configuration.getDisableBusinessEndpoints()) {
                environment.jersey().register((Object)new VersionResources((AutomateApplication)this, (AutomateConfiguration)configuration));
            }
            environment.jersey().register((Object)new HealthResource((AutomateApplication)this, (AutomateConfiguration)configuration));
            this.registrationWorker = new RegistrationWorker(this);
            if (configuration.getApiTracking() == null) {
                configuration.setApiTracking(new ApiTrackingConfiguration());
            }
            environment.jersey().register((Object)UriListener.getInstance());
            this.registerRestApiUsageTracking(environment, configuration.getApiTracking().getBatchSize(), configuration.getApiTracking().getMaxBatchTimeMillis());
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
            this.closeWithDelay(1000L);
            System.exit(1);
        }
        this.initializing = false;
    }

    public ConfigurationDao getEngineServerConfigurationDao() {
        return this.engineServerConfigurationDao;
    }

    public CentralizedLogInterceptor<ILoggingEvent> getCentralizedLoggingAppender() {
        return this.centralizedLoggingAppender;
    }

    public void startCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().start();
    }

    public void stopCentralizedLoggingAdapter() {
        this.getCentralizedLoggingAppender().stop();
    }

    public HealthInfo getHealthInfo() {
        try {
            this.engineServerConfigurationDao.getIds();
        }
        catch (Exception e) {
            LOGGER.error("Health check error", (Throwable)e);
            return new HealthInfo("DB error", (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (this.configuration.getAutoRegistrationSchedulerUrl() != null) {
            DateTime lastPingDate = this.getConfigResource().getLastPingDateTime();
            long age = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lastPingDate.getMillis();
            if (lastPingDate == null || age > this.getConfiguration().getRegistrationPingInterval()) {
                return new HealthInfo("Scheduler registration timeout", (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return new HealthInfo("OK", (Response.StatusType)Response.Status.OK);
    }

    public boolean getInitializing() {
        return this.initializing;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void updateInstanceId(String instanceId) {
        this.engineServerConfigurationDao.deleteId(this.instanceId);
        this.instanceId = instanceId;
        try {
            this.engineServerConfigurationDao.addId(this.instanceId);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    public void closeWithDelay(long delay) {
        LOGGER.info("Preparing to close application");
        Thread closingThread = new Thread(() -> {
            LOGGER.info("Cleaning up");
            if (this.serverEnginesResource != null) {
                try {
                    this.serverEnginesResource.setClosing();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot set closing", (Throwable)e);
                }
            }
            if (this.serverEnginesResource != null) {
                for (EngineWorker engineWorker : this.serverEnginesResource.getEngineWorkers().values()) {
                    try {
                        if (engineWorker == null) continue;
                        engineWorker.close();
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot close Engine Worker", (Throwable)e);
                    }
                }
            }
            try {
                if (delay > 0L) {
                    LOGGER.info("Waiting " + delay + " ms before stopping ...");
                    Thread.sleep(delay);
                    LOGGER.info("Finished waiting");
                }
                LOGGER.info("Closing application");
                this.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close application", (Throwable)e);
            }
            finally {
                System.exit(0);
            }
        });
        closingThread.setName("Automate Engine Server - Close Thread");
        closingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() throws Exception {
        if (!this.closing) {
            this.closing = true;
            try {
                for (EngineWorker engineWorker : this.getServerEnginesResource().getEngineWorkers().values()) {
                    try {
                        if (engineWorker == null) continue;
                        engineWorker.close();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot close Engine worker", (Throwable)e);
                    }
                }
            }
            finally {
                this.environment.getApplicationContext().getServer().stop();
                System.exit(0);
            }
        }
    }

    private void registerRestApiUsageTracking(Environment environment, int batchSize, long maxBatchTimeMillis) {
        LOGGER.info("Registering apiUsageServletFilter...");
        Consumer<RestApiUsageBatch> restApiUtilizationConsumer = batch -> {
            UtilizationRecords utilizationRecords = new UtilizationRecords();
            utilizationRecords.setId(UidUtils.getRandom());
            List serverRestApiUsage = batch.getApiMethodCountMap().entrySet().stream().map(entry -> {
                ConsumptionEvent consumptionEvent = new ConsumptionEvent();
                consumptionEvent.setConsumptionEventId(UUID.randomUUID().toString());
                consumptionEvent.setLicenseId(Optional.ofNullable(this.serverRampivaLicence.getLicenceInfo()).map(licenceInfo -> licenceInfo.getId()).orElse(""));
                consumptionEvent.setConsumptionStartEpoch(batch.getBatchStartedEpoch().longValue());
                consumptionEvent.setConsumptionEndEpoch(new Date().getTime());
                consumptionEvent.setPlatformType(ConsumptionPlatformType.NUIX_AUTOMATE);
                consumptionEvent.setPlatformId(AutomateModule.AUTOMATE_SERVER_SERVICE.getValue());
                consumptionEvent.setConsumptionType(ConsumptionType.REST_API);
                consumptionEvent.setUnitType(UnitType.CALLS);
                consumptionEvent.setUnits((long)((AtomicInteger)entry.getValue()).get());
                String key = (String)entry.getKey();
                String origin = "";
                String method = "";
                String requestUri = "";
                if (key.contains(":")) {
                    String[] originAndMethodSpaceRequestUri = key.split(":");
                    origin = originAndMethodSpaceRequestUri[0];
                    String[] methodAndRequestUri = originAndMethodSpaceRequestUri[1].split(" ");
                    method = methodAndRequestUri[0];
                    requestUri = methodAndRequestUri[1];
                } else {
                    String[] methodAndRequestUri = ((String)entry.getKey()).split(" ");
                    method = methodAndRequestUri[0];
                    requestUri = methodAndRequestUri[1];
                }
                if (origin != null) {
                    consumptionEvent.setConsumptionSubType(ConsumptionSubType.AUTOMATE_INTERNAL_ACCESS);
                } else {
                    consumptionEvent.setConsumptionSubType(ConsumptionSubType.EXTERNAL_ACCESS);
                }
                consumptionEvent.setResourceType(ResourceType.REST_ENDPOINT);
                consumptionEvent.setResourceId(requestUri);
                consumptionEvent.setResourceSubType(ResourceSubType.HTTP_METHOD);
                consumptionEvent.setResourceSubId(method);
                return consumptionEvent;
            }).collect(Collectors.toList());
            this.getConsumptionResource().addConsumption(new Consumption(serverRestApiUsage));
        };
        AccessLogDataProcessor accessLogDataProcessor = new AccessLogDataProcessor(batchSize, maxBatchTimeMillis, restApiUtilizationConsumer);
        RestApiUsageServletFilter restApiUsageServletFilter = new RestApiUsageServletFilter(accessLogDataProcessor, s -> {
            try {
                return this.bearerAuthenticator.authenticate(s.getHeader("Authorization")).isPresent();
            }
            catch (AuthenticationException e) {
                return false;
            }
        });
        environment.servlets().addFilter("restApiUsageServletFilter", (Filter)restApiUsageServletFilter).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
    }
}

