/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.api.internal.configuration.ApiTrackingConfiguration;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import io.dropwizard.Configuration;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.web.conf.WebConfiguration;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerConfiguration
extends Configuration
implements AutomateConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(ServerConfiguration.class);
    private String apiSecret = null;
    private boolean debugLogRequestResponse = false;
    private String engineId = null;
    private String jobId = null;
    private String serverInstanceId = null;
    private boolean enableCentralizedLogging = true;
    private int centralizedLoggingRetention = 30;
    private long centralizedLoggingMaxSize = 1000000000L;
    private int centralizedLoggingMaxActiveLines = 10000;
    private String jobFilesDirectory = "C:\\Temp\\EngineServer\\Files";
    private int serverLocalPort = 0;
    private String serverLocalName = "SFN-Server";
    private long nameResolutionTimeout = 500L;
    private String corsAllowedOrigins = null;
    private String corsAllowedHeaders = null;
    private String corsAllowedMethods = null;
    private boolean disableResponseCache = false;
    private long responseCacheMaxValidity = 300000L;
    private long globalResponseCacheMaxValidity = 3600000L;
    private long nuixLicenseSourceTimeout = 30000L;
    private long schedulerTombstoneDuration = 60000L;
    private boolean enableEngineJavaMinidumps = false;
    private long apiClientConnectionTimeout = 5000L;
    private long apiClientReadTimeout = 45000L;
    private String nuixEnginePath = null;
    private long enginePingInterval = 1000L;
    private long engineErrorDelay = 1000L;
    private long engineInitKeepAlive = 5000L;
    private long engineKeepAlive = 3600000L;
    private long engineTimeout = 300000L;
    private long engineShutdownTimeout = 10000L;
    private long engineInitRetryDelay = 30000L;
    private int engineInitTimeout = 120;
    private long engineAbortTimeout = 5000L;
    private String engineInitLogFolder = "C:\\Temp\\logs";
    private String log4jConfigurationFile = "C:\\ProgramData\\Nuix\\Automate\\EngineServer\\config\\log4j.properties";
    private String workerBrokerIP = null;
    private Integer workerBrokerStartPort = null;
    private Integer workerBrokerEndPort = null;
    private int workerBrokerInitAttempts = 100;
    private int jobRunningLogMaxSize = 20;
    private boolean disableBusinessEndpoints = false;
    private String autoRegistrationServerName;
    private String autoRegistrationServerUrl;
    private String autoRegistrationSchedulerUrl;
    private String registrationSchedulerWhitelistedCertificateFingerprint;
    private String autoRegistrationSchedulerResourcePoolId;
    private String autoRegistrationSchedulerResourcePoolAccessKey;
    private Set<EngineRole> autoRegistrationRoles;
    private long registrationPingInterval = 5000L;
    private long registrationBootstrapDelay = 1000L;
    private Map<String, String> engineArchAdditionalJavaParameters;
    private ApiTrackingConfiguration apiTracking;
    private WebConfiguration webConfiguration = new WebConfiguration();
    @JsonProperty
    private DataSourceFactory engineServerConfigurationStore;
    @JsonProperty
    private DataSourceFactory applicationStore;

    public ServerConfiguration() {
        if (this.engineArchAdditionalJavaParameters == null) {
            this.engineArchAdditionalJavaParameters = new HashMap<String, String>();
            this.engineArchAdditionalJavaParameters.put("arm64", "-Dnuix.pdf.pdfToTextLibrary=itext");
            this.engineArchAdditionalJavaParameters.put("aarch64", "-Dnuix.pdf.pdfToTextLibrary=itext");
        }
    }

    public SchedulerComponent getRole() {
        return SchedulerComponent.ENGINE_SERVER;
    }

    public void setRole(SchedulerComponent role) {
    }

    public String getEngineId() {
        return null;
    }

    public String getJobId() {
        return null;
    }

    public WebConfiguration getWebConfiguration() {
        return this.webConfiguration;
    }

    public void setWebConfiguration(WebConfiguration webConfiguration) {
        this.webConfiguration = webConfiguration;
    }

    private void initializeStoresEnv() {
        String enabledStore = System.getenv("AUTOMATE_STORE_APPLICATION_ENABLED");
        if (enabledStore != null) {
            String driverClass;
            LOGGER.info((Object)"Overwriting Application Store from ENV");
            boolean enabled = Boolean.parseBoolean(enabledStore);
            if (enabled && (driverClass = System.getenv("AUTOMATE_STORE_APPLICATION_DRIVER_CLASS")) != null) {
                String minConnections;
                String charset;
                String password;
                this.applicationStore = new DataSourceFactory();
                String url = System.getenv("AUTOMATE_STORE_APPLICATION_URL");
                LOGGER.info((Object)("Overwriting Application Store configuration from ENV to " + url));
                this.applicationStore.setDriverClass(driverClass);
                this.applicationStore.setUrl(url);
                String username = System.getenv("AUTOMATE_STORE_APPLICATION_USERNAME");
                if (username != null) {
                    this.applicationStore.setUser(username);
                }
                if ((password = System.getenv("AUTOMATE_STORE_APPLICATION_PASSWORD")) != null) {
                    this.applicationStore.setPassword(password);
                }
                if ((charset = System.getenv("AUTOMATE_STORE_APPLICATION_CHARSET")) != null) {
                    this.applicationStore.getProperties().put("charset", charset);
                }
                if ((minConnections = System.getenv("AUTOMATE_STORE_APPLICATION_SERVER_MIN_CONNECTIONS")) != null) {
                    LOGGER.info((Object)("Overwriting Application Store Server min connections " + minConnections));
                    this.applicationStore.setMinSize(Integer.parseInt(minConnections));
                    this.applicationStore.setInitialSize(Integer.parseInt(minConnections));
                }
                String maxConnections = System.getenv("AUTOMATE_STORE_APPLICATION_SERVER_MAX_CONNECTIONS");
                if (minConnections != null) {
                    LOGGER.info((Object)("Overwriting Application Store Server max connections " + maxConnections));
                    this.applicationStore.setMaxSize(Integer.parseInt(maxConnections));
                }
            }
        }
    }

    private void initializeAccessKeyEnv() {
        String engineServerIdEnv;
        String apiSecretEnv = System.getenv("AUTOMATE_API_KEY");
        if (apiSecretEnv != null) {
            LOGGER.info((Object)"Overwriting API Secret env");
            this.apiSecret = apiSecretEnv;
        }
        if ((engineServerIdEnv = System.getenv("AUTOMATE_SERVER_ID")) != null) {
            LOGGER.info((Object)"Overwriting Engine Server ID env");
            this.serverInstanceId = engineServerIdEnv;
        }
    }

    public void initializeFromEnv() {
        this.initializeStoresEnv();
        this.initializeAccessKeyEnv();
        this.initializeSelfRegistrationEnv();
        this.initializeGenericEnv();
    }

    private void initializeSelfRegistrationEnv() {
        String enableRegistration = System.getenv("AUTOMATE_REGISTRATION_ENABLED");
        if (enableRegistration != null) {
            LOGGER.info((Object)"Overwriting Registration from ENV");
            boolean enabled = Boolean.parseBoolean(enableRegistration);
            if (enabled) {
                String roleRemote;
                this.autoRegistrationServerName = System.getenv("AUTOMATE_REGISTRATION_SERVER_NAME");
                LOGGER.info((Object)("Setting Registration Server Name from ENV: " + this.autoRegistrationServerName));
                this.autoRegistrationServerUrl = System.getenv("AUTOMATE_REGISTRATION_SERVER_URL");
                LOGGER.info((Object)("Setting Registration Server URL from ENV: " + this.autoRegistrationServerUrl));
                this.autoRegistrationSchedulerUrl = System.getenv("AUTOMATE_REGISTRATION_SCHEDULER_URL");
                LOGGER.info((Object)("Setting Registration Scheduler URL from ENV: " + this.autoRegistrationSchedulerUrl));
                this.autoRegistrationSchedulerResourcePoolId = System.getenv("AUTOMATE_REGISTRATION_RESOURCE_POOL_ID");
                if (this.autoRegistrationSchedulerResourcePoolId != null) {
                    LOGGER.info((Object)("Setting Registration Resource Pool ID from ENV: " + this.autoRegistrationSchedulerResourcePoolId));
                } else {
                    this.autoRegistrationSchedulerResourcePoolId = "1000b196-09b3-4c2a-8b85-38863cf04aec";
                }
                this.autoRegistrationSchedulerResourcePoolAccessKey = System.getenv("AUTOMATE_REGISTRATION_RESOURCE_POOL_ACCESS_KEY");
                LOGGER.info((Object)"Setting Registration Resource Pool Access Key from ENV");
                this.autoRegistrationRoles = new HashSet<EngineRole>();
                String roleMain = System.getenv("AUTOMATE_REGISTRATION_ROLE_MAIN");
                if (roleMain != null && Boolean.parseBoolean(roleMain)) {
                    this.autoRegistrationRoles.add(EngineRole.MAIN);
                }
                if ((roleRemote = System.getenv("AUTOMATE_REGISTRATION_ROLE_REMOTE")) != null && Boolean.parseBoolean(roleRemote)) {
                    this.autoRegistrationRoles.add(EngineRole.REMOTE);
                }
                if (this.autoRegistrationRoles.size() == 0) {
                    LOGGER.warn((Object)"No Engine role specified, defaulting to Main + Remote role");
                    this.autoRegistrationRoles.add(EngineRole.MAIN);
                    this.autoRegistrationRoles.add(EngineRole.REMOTE);
                }
            }
        }
    }

    private void initializeGenericEnv() {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            String fieldName = field.getName();
            String envCandidate = "AUTOMATE_" + FormattingUtils.camelCaseToSnakeCase((String)fieldName).toUpperCase();
            LOGGER.debug((Object)("Testing setting " + fieldName + " for ENV variable " + envCandidate));
            String envValue = System.getenv(envCandidate);
            if (envValue == null) continue;
            try {
                Object fieldValue = field.getType().equals(String.class) ? envValue : SerializationUtils.fromJson((String)envValue, field.getType());
                field.set((Object)this, fieldValue);
                LOGGER.info((Object)("Set " + fieldName + " of type " + field.getType() + " from ENV variable " + envCandidate + " value " + envValue));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error setting " + fieldName + " of type " + field.getType() + " from ENV variable " + envCandidate + " value " + envValue), (Throwable)e);
            }
        }
    }

    public String getApiSecret() {
        if (this.apiSecret.equals("changeme")) {
            LOGGER.error((Object)"Default apiSecret detected, API authentication is disabled");
            this.apiSecret = UidUtils.getRandom();
        }
        return this.apiSecret;
    }

    public void setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
    }

    public void initApplicationStore() {
        if (this.applicationStore == null) {
            this.applicationStore = this.getEngineServerConfigurationStore();
        }
    }

    public DataSourceFactory getEngineServerConfigurationStore() {
        if (this.engineServerConfigurationStore == null) {
            File f = new File(this.getInstallationPath("EngineServer") + "/stores");
            if (!f.exists()) {
                f.mkdirs();
            }
            this.engineServerConfigurationStore = new DataSourceFactory();
            this.engineServerConfigurationStore.setDriverClass("org.sqlite.JDBC");
            this.engineServerConfigurationStore.setUrl("jdbc:sqlite:" + this.getInstallationPath("EngineServer") + "/stores/configuration.db");
            this.engineServerConfigurationStore.setUser("engine-server");
        }
        return this.engineServerConfigurationStore;
    }

    public DataSourceFactory getApplicationStore() {
        return this.applicationStore;
    }

    public String getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    public void setCorsAllowedOrigins(String corsAllowedOrigins) {
        this.corsAllowedOrigins = corsAllowedOrigins;
    }

    public String getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    public void setCorsAllowedHeaders(String corsAllowedHeaders) {
        this.corsAllowedHeaders = corsAllowedHeaders;
    }

    public String getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    public void setCorsAllowedMethods(String corsAllowedMethods) {
        this.corsAllowedMethods = corsAllowedMethods;
    }

    public boolean getEnableCentralizedLogging() {
        return this.enableCentralizedLogging;
    }

    public void setEnableCentralizedLogging(boolean enableCentralizedLogging) {
        this.enableCentralizedLogging = enableCentralizedLogging;
    }

    public int getCentralizedLoggingRetention() {
        return this.centralizedLoggingRetention;
    }

    public void setCentralizedLoggingRetention(int centralizedLoggingRetention) {
        this.centralizedLoggingRetention = centralizedLoggingRetention;
    }

    public long getCentralizedLoggingMaxSize() {
        return this.centralizedLoggingMaxSize;
    }

    public void setCentralizedLoggingMaxSize(long centralizedLoggingMaxSize) {
        this.centralizedLoggingMaxSize = centralizedLoggingMaxSize;
    }

    public int getCentralizedLoggingMaxActiveLines() {
        return this.centralizedLoggingMaxActiveLines;
    }

    public void setCentralizedLoggingMaxActiveLines(int centralizedLoggingMaxActiveLines) {
        this.centralizedLoggingMaxActiveLines = centralizedLoggingMaxActiveLines;
    }

    public int getServerLocalPort() {
        return this.serverLocalPort;
    }

    public void setServerLocalPort(int serverLocalPort) {
        this.serverLocalPort = serverLocalPort;
    }

    public String getServerLocalName() {
        return this.serverLocalName;
    }

    public void setServerLocalName(String serverLocalName) {
        this.serverLocalName = serverLocalName;
    }

    public boolean getDisableResponseCache() {
        return this.disableResponseCache;
    }

    public void setDisableResponseCache(boolean disableResponseCache) {
        this.disableResponseCache = disableResponseCache;
    }

    public long getResponseCacheMaxValidity() {
        return this.responseCacheMaxValidity;
    }

    public void setResponseCacheMaxValidity(long responseCacheMaxValidity) {
        this.responseCacheMaxValidity = responseCacheMaxValidity;
    }

    public long getGlobalResponseCacheMaxValidity() {
        return this.globalResponseCacheMaxValidity;
    }

    public void setGlobalResponseCacheMaxValidity(long globalResponseCacheMaxValidity) {
        this.globalResponseCacheMaxValidity = globalResponseCacheMaxValidity;
    }

    public long getNameResolutionTimeout() {
        return this.nameResolutionTimeout;
    }

    public void setNameResolutionTimeout(long nameResolutionTimeout) {
        this.nameResolutionTimeout = nameResolutionTimeout;
    }

    public boolean getDebugLogRequestResponse() {
        return this.debugLogRequestResponse;
    }

    public void setDebugLogRequestResponse(boolean debugLogRequestResponse) {
        this.debugLogRequestResponse = debugLogRequestResponse;
    }

    public boolean getDisableBusinessEndpoints() {
        return this.disableBusinessEndpoints;
    }

    public void setDisableBusinessEndpoints(boolean disableBusinessEndpoints) {
        this.disableBusinessEndpoints = disableBusinessEndpoints;
    }

    public long getSchedulerTombstoneDuration() {
        return this.schedulerTombstoneDuration;
    }

    public void setSchedulerTombstoneDuration(long schedulerTombstoneDuration) {
        this.schedulerTombstoneDuration = schedulerTombstoneDuration;
    }

    public long getEnginePingInterval() {
        return this.enginePingInterval;
    }

    public void setEnginePingInterval(long enginePingInterval) {
        this.enginePingInterval = enginePingInterval;
    }

    public long getEngineErrorDelay() {
        return this.engineErrorDelay;
    }

    public void setEngineErrorDelay(long engineErrorDelay) {
        this.engineErrorDelay = engineErrorDelay;
    }

    public long getEngineInitKeepAlive() {
        return this.engineInitKeepAlive;
    }

    public void setEngineInitKeepAlive(long engineInitKeepAlive) {
        this.engineInitKeepAlive = engineInitKeepAlive;
    }

    public long getEngineKeepAlive() {
        return this.engineKeepAlive;
    }

    public void setEngineKeepAlive(long engineKeepAlive) {
        this.engineKeepAlive = engineKeepAlive;
    }

    public long getEngineTimeout() {
        return this.engineTimeout;
    }

    public void setEngineTimeout(long engineTimeout) {
        this.engineTimeout = engineTimeout;
    }

    public long getEngineShutdownTimeout() {
        return this.engineShutdownTimeout;
    }

    public void setEngineShutdownTimeout(long engineShutdownTimeout) {
        this.engineShutdownTimeout = engineShutdownTimeout;
    }

    public long getEngineInitRetryDelay() {
        return this.engineInitRetryDelay;
    }

    public void setEngineInitRetryDelay(long engineInitRetryDelay) {
        this.engineInitRetryDelay = engineInitRetryDelay;
    }

    public long getEngineAbortTimeout() {
        return this.engineAbortTimeout;
    }

    public void setEngineAbortTimeout(long engineAbortTimeout) {
        this.engineAbortTimeout = engineAbortTimeout;
    }

    public String getNuixEnginePath() {
        return this.nuixEnginePath;
    }

    public void setNuixEnginePath(String nuixEnginePath) {
        this.nuixEnginePath = nuixEnginePath;
    }

    public int getEngineInitTimeout() {
        return this.engineInitTimeout;
    }

    public void setEngineInitTimeout(int engineInitTimeout) {
        this.engineInitTimeout = engineInitTimeout;
    }

    public String getLog4jConfigurationFile() {
        return this.log4jConfigurationFile;
    }

    public void setLog4jConfigurationFile(String log4jConfigurationFile) {
        this.log4jConfigurationFile = log4jConfigurationFile;
    }

    public String getWorkerBrokerIP() {
        return this.workerBrokerIP;
    }

    public void setWorkerBrokerIP(String workerBrokerIP) {
        this.workerBrokerIP = workerBrokerIP;
    }

    public Integer getWorkerBrokerStartPort() {
        return this.workerBrokerStartPort;
    }

    public void setWorkerBrokerStartPort(Integer workerBrokerStartPort) {
        this.workerBrokerStartPort = workerBrokerStartPort;
    }

    public Integer getWorkerBrokerEndPort() {
        return this.workerBrokerEndPort;
    }

    public void setWorkerBrokerEndPort(Integer workerBrokerEndPort) {
        this.workerBrokerEndPort = workerBrokerEndPort;
    }

    public int getWorkerBrokerInitAttempts() {
        return this.workerBrokerInitAttempts;
    }

    public void setWorkerBrokerInitAttempts(int workerBrokerInitAttempts) {
        this.workerBrokerInitAttempts = workerBrokerInitAttempts;
    }

    public int getJobRunningLogMaxSize() {
        return this.jobRunningLogMaxSize;
    }

    public void setJobRunningLogMaxSize(int jobRunningLogMaxSize) {
        this.jobRunningLogMaxSize = jobRunningLogMaxSize;
    }

    public String getEngineInitLogFolder() {
        return this.engineInitLogFolder;
    }

    public void setEngineInitLogFolder(String engineInitLogFolder) {
        this.engineInitLogFolder = engineInitLogFolder;
    }

    public String getJobFilesDirectory() {
        return this.jobFilesDirectory;
    }

    public void setJobFilesDirectory(String jobFilesDirectory) {
        this.jobFilesDirectory = jobFilesDirectory;
    }

    public long getNuixLicenseSourceTimeout() {
        return this.nuixLicenseSourceTimeout;
    }

    public void setNuixLicenseSourceTimeout(long nuixLicenseSourceTimeout) {
        this.nuixLicenseSourceTimeout = nuixLicenseSourceTimeout;
    }

    public boolean getEnableEngineJavaMinidumps() {
        return this.enableEngineJavaMinidumps;
    }

    public void setEnableEngineJavaMinidumps(boolean enableEngineJavaMinidumps) {
        this.enableEngineJavaMinidumps = enableEngineJavaMinidumps;
    }

    public long getApiClientConnectionTimeout() {
        return this.apiClientConnectionTimeout;
    }

    public void setApiClientConnectionTimeout(long apiClientConnectionTimeout) {
        this.apiClientConnectionTimeout = apiClientConnectionTimeout;
    }

    public long getApiClientReadTimeout() {
        return this.apiClientReadTimeout;
    }

    public void setApiClientReadTimeout(long apiClientReadTimeout) {
        this.apiClientReadTimeout = apiClientReadTimeout;
    }

    private String getInstallationPath(String product) {
        if (ServerConfiguration.getOsWindows()) {
            return "C:/ProgramData/Nuix/Automate/" + product;
        }
        return "/etc/nuix/automate/" + product.toLowerCase().replace(" ", "-").replace("engineserver", "engine-server");
    }

    public static boolean getOsWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public String getServerInstanceId() {
        return this.serverInstanceId;
    }

    public long getRegistrationPingInterval() {
        return this.registrationPingInterval;
    }

    public void setRegistrationPingInterval(long registrationPingInterval) {
        this.registrationPingInterval = registrationPingInterval;
    }

    public String getAutoRegistrationServerName() {
        return this.autoRegistrationServerName;
    }

    public void setAutoRegistrationServerName(String autoRegistrationServerName) {
        this.autoRegistrationServerName = autoRegistrationServerName;
    }

    public String getAutoRegistrationServerUrl() {
        return this.autoRegistrationServerUrl;
    }

    public void setAutoRegistrationServerUrl(String autoRegistrationServerUrl) {
        this.autoRegistrationServerUrl = autoRegistrationServerUrl;
    }

    public String getAutoRegistrationSchedulerUrl() {
        return this.autoRegistrationSchedulerUrl;
    }

    public void setAutoRegistrationSchedulerUrl(String autoRegistrationSchedulerUrl) {
        this.autoRegistrationSchedulerUrl = autoRegistrationSchedulerUrl;
    }

    public String getAutoRegistrationSchedulerResourcePoolId() {
        return this.autoRegistrationSchedulerResourcePoolId;
    }

    public void setAutoRegistrationSchedulerResourcePoolId(String autoRegistrationSchedulerResourcePoolId) {
        this.autoRegistrationSchedulerResourcePoolId = autoRegistrationSchedulerResourcePoolId;
    }

    public String getAutoRegistrationSchedulerResourcePoolAccessKey() {
        return this.autoRegistrationSchedulerResourcePoolAccessKey;
    }

    public void setAutoRegistrationSchedulerResourcePoolAccessKey(String autoRegistrationSchedulerResourcePoolAccessKey) {
        this.autoRegistrationSchedulerResourcePoolAccessKey = autoRegistrationSchedulerResourcePoolAccessKey;
    }

    public String getRegistrationSchedulerWhitelistedCertificateFingerprint() {
        return this.registrationSchedulerWhitelistedCertificateFingerprint;
    }

    public void setRegistrationSchedulerWhitelistedCertificateFingerprint(String registrationSchedulerWhitelistedCertificateFingerprint) {
        this.registrationSchedulerWhitelistedCertificateFingerprint = registrationSchedulerWhitelistedCertificateFingerprint;
    }

    public long getRegistrationBootstrapDelay() {
        return this.registrationBootstrapDelay;
    }

    public void setRegistrationBootstrapDelay(long registrationBootstrapDelay) {
        this.registrationBootstrapDelay = registrationBootstrapDelay;
    }

    public Set<EngineRole> getAutoRegistrationRoles() {
        return this.autoRegistrationRoles;
    }

    public void setAutoRegistrationRoles(Set<EngineRole> autoRegistrationRoles) {
        this.autoRegistrationRoles = autoRegistrationRoles;
    }

    public Map<String, String> getEngineArchAdditionalJavaParameters() {
        return this.engineArchAdditionalJavaParameters;
    }

    public void setEngineArchAdditionalJavaParameters(Map<String, String> engineArchAdditionalJavaParameters) {
        this.engineArchAdditionalJavaParameters = engineArchAdditionalJavaParameters;
    }

    public void setApiTracking(ApiTrackingConfiguration apiTrackingConfiguration) {
        this.apiTracking = apiTrackingConfiguration;
    }

    public ApiTrackingConfiguration getApiTracking() {
        return this.apiTracking;
    }
}

