/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.configuration.VersionedModel;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.NameResolver;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.engine.ServerId;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/server/config")
@Produces(value={"application/json"})
public class ConfigResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConfigResource.class);
    private ServerApplication serverApplication;
    private String lastSchedulerId;
    private String lastSchedulerHost;
    private DateTime lastPingDateTime;
    private NameResolver nameResolver;

    public ConfigResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.nameResolver = new NameResolver(serverApplication.getConfiguration().getNameResolutionTimeout());
    }

    @Path(value="/id")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getId(@QueryParam(value="schedulerId") String schedulerId) {
        if (schedulerId == null || schedulerId.length() < 16) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidSchedulerId")).build();
        }
        ServerId serverId = new ServerId();
        serverId.setId(this.serverApplication.getInstanceId());
        serverId.setNonce(UidUtils.getRandom());
        String apiToken = this.serverApplication.getBearerAuthenticator().getTokenFromApiSecret(schedulerId, serverId.getNonce());
        serverId.setKey(apiToken);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)serverId).build();
    }

    @Path(value="/id")
    @PUT
    public Response generateNewId(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Refreshing ID, current ID: " + this.serverApplication.getInstanceId());
        this.serverApplication.getServerEnginesResource().removeAllEnginesInternal();
        this.serverApplication.updateInstanceId(UidUtils.getRandom());
        LOGGER.info("Refreshed ID: " + this.serverApplication.getInstanceId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.serverApplication.getInstanceId()).build();
    }

    @Path(value="/nuixLicenceSources")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refreshNuixLicenceSources(@Auth BearerUser user, VersionedModel<NuixLicenseSourceModel> nuixLicenceSourcesModel) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received Engine licence sources version " + nuixLicenceSourcesModel.getVersion());
        HashMap<String, NuixLicenseSourceModel> nuixLicenceSources = new HashMap<String, NuixLicenseSourceModel>();
        for (NuixLicenseSourceModel nuixLicenseSource : nuixLicenceSourcesModel.getModels()) {
            nuixLicenceSources.put(nuixLicenseSource.getId(), nuixLicenseSource);
        }
        this.serverApplication.setServerNuixLicenceSources(nuixLicenceSources);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)nuixLicenceSourcesModel.getVersion()).build();
    }

    @Path(value="/rampivaLicence")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refreshRampivaLicence(@Auth BearerUser user, VersionedModel<AutomateLicenceModel> rampivaLicenceModel) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received Automate Licence version " + rampivaLicenceModel.getVersion());
        AutomateLicenceModel rampivaLicence = null;
        Iterator iterator = rampivaLicenceModel.getModels().iterator();
        while (iterator.hasNext()) {
            AutomateLicenceModel licence;
            rampivaLicence = licence = (AutomateLicenceModel)iterator.next();
        }
        this.serverApplication.setServerRampivaLicence(rampivaLicence);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)rampivaLicenceModel.getVersion()).build();
    }

    @Path(value="/executionProfiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refreshExecutionProfiles(@Auth BearerUser user, VersionedModel<ExecutionProfileModel> executionProfiles) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received Execution Profiles version " + executionProfiles.getVersion());
        HashMap<String, ExecutionProfileModel> executionProfilesMap = new HashMap<String, ExecutionProfileModel>();
        for (ExecutionProfileModel executionProfile : executionProfiles.getModels()) {
            executionProfilesMap.put(executionProfile.getId(), executionProfile);
        }
        this.serverApplication.setServerExecutionProfiles(executionProfilesMap);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)executionProfiles.getVersion()).build();
    }

    @Path(value="/networkConfiguration")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refreshNetworkConfiguration(@Auth BearerUser user, VersionedModel<NetworkConfiguration> networkConfigurationVersionedModel) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        LOGGER.info("Received Network Configuration version " + networkConfigurationVersionedModel.getVersion());
        NetworkConfiguration networkConfiguration = null;
        Iterator iterator = networkConfigurationVersionedModel.getModels().iterator();
        while (iterator.hasNext()) {
            NetworkConfiguration configuration;
            networkConfiguration = configuration = (NetworkConfiguration)iterator.next();
        }
        if (networkConfiguration != null && networkConfiguration.isProxyConfigured()) {
            this.serverApplication.getServerNetworkConfiguration().update(networkConfiguration);
            this.serverApplication.getServerNetworkConfiguration().setId(networkConfiguration.getId());
        } else {
            this.serverApplication.getServerNetworkConfiguration().clear();
        }
        LOGGER.info(this.serverApplication.getServerNetworkConfiguration().proxySettingsToString());
        DropwizardRestClientFactory.restartClients();
        WsRsRestClientFactory.restartClients();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)networkConfigurationVersionedModel.getVersion()).build();
    }

    @Path(value="/ping")
    @GET
    public Response ping(@Auth BearerUser user, @QueryParam(value="serverId") String serverId, @QueryParam(value="enableCentralizedLogging") boolean enableCentralizedLogging, @Context HttpServletRequest request) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        if (serverId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("missingServerId")).build();
        }
        if (this.lastSchedulerId != null && !this.lastSchedulerId.equals(serverId)) {
            String currentSchedulerHost = this.nameResolver.getRemoteName(request);
            long age = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastPingDateTime.getMillis();
            if (age < this.serverApplication.getConfiguration().getSchedulerTombstoneDuration()) {
                LOGGER.warn("Attempted to managed Engine Server from Scheduler " + currentSchedulerHost + " but Engine Server is already managed by Scheduler " + this.lastSchedulerHost);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("engineServerManagedByDifferentInstance", (Map)new HashMap<String, String>(){
                    {
                        this.put("lastSchedulerHost", ConfigResource.this.lastSchedulerHost);
                    }
                })).build();
            }
        }
        if (this.lastSchedulerId == null) {
            this.lastSchedulerHost = this.nameResolver.getRemoteName(request);
            LOGGER.info("Managing Engine Server by Scheduler " + this.lastSchedulerHost);
        }
        this.lastSchedulerId = serverId;
        this.lastPingDateTime = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        LogHandler logHandler = LogHandler.getInstance();
        logHandler.updateLogHandler(enableCentralizedLogging);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.serverApplication.getInstanceId()).build();
    }

    public DateTime getLastPingDateTime() {
        return this.lastPingDateTime;
    }
}

