/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/server/session")
@Produces(value={"application/json"})
public class SessionResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SessionResource.class);
    private ServerApplication serverApplication;
    private Map<String, EventInfo> eventsMap;

    public SessionResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.eventsMap = new ConcurrentHashMap<String, EventInfo>();
    }

    @GET
    public Response getEvents(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        ArrayList<EventInfo> events = new ArrayList<EventInfo>();
        events.addAll(this.eventsMap.values());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(events).build();
    }

    public void addEvent(EventInfo eventInfo) {
        this.eventsMap.put(eventInfo.getId(), eventInfo);
    }

    @DELETE
    @Path(value="/{id}")
    public Response removeEvent(@Auth BearerUser user, @PathParam(value="id") String id) {
        id = new String(Base64.getDecoder().decode(id), StandardCharsets.UTF_8);
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.eventsMap.remove(id);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("utilizationRemoved")).build();
    }
}

