/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.userdatadir.FileInfo;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/server/userDataDir")
@Produces(value={"application/json"})
public class UserDataDirResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserDataDirResource.class);
    private java.nio.file.Path userDataDirPath = null;

    public java.nio.file.Path getUserDataDirPath() {
        return this.userDataDirPath;
    }

    @Path(value="/files")
    @GET
    public Response getUserDataDirFiles(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return ExceptionUtils.toResponse((String)"userNotAllowedToUseApi", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        try {
            Map<String, FileInfo> fileInfos = this.buildUserDataDirFileInfos();
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(fileInfos).build();
        }
        catch (IOException e) {
            return ExceptionUtils.toResponse((String)"errorGettingUserDataDirFiles");
        }
    }

    @Path(value="/config")
    @POST
    @Consumes(value={"application/json"})
    public Response configureUserDataDir(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, String userDataDirPath) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return ExceptionUtils.toResponse((String)"userNotAllowedToUseApi", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        if (userDataDirPath == null || userDataDirPath.isEmpty()) {
            LOGGER.info("Removed user data dir");
            this.userDataDirPath = null;
        } else {
            java.nio.file.Path filePath = Paths.get(userDataDirPath, new String[0]);
            try {
                if (!Files.exists(filePath, new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error creating parent directories for file: " + filePath, (Throwable)e);
            }
            LOGGER.info("Configured user data dir: " + filePath);
            this.userDataDirPath = filePath;
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
    }

    @Path(value="/files")
    @POST
    @Consumes(value={"application/octet-stream"})
    public Response uploadUserDataDirFile(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @QueryParam(value="relativePath") String relativePath, @QueryParam(value="createdTime") long createdTime, @QueryParam(value="lastModifiedTime") long lastModifiedTime) {
        FileInfo fileInfo;
        java.nio.file.Path filePath;
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return ExceptionUtils.toResponse((String)"userNotAllowedToUseApi", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        if (this.userDataDirPath == null) {
            return ExceptionUtils.toResponse((String)"folderDoesNotExist", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            filePath = FileUtils.safeResolveParent((java.nio.file.Path)this.userDataDirPath, (String[])new String[]{relativePath});
        }
        catch (FileTraversalException e) {
            LOGGER.error("Error uploading userDataDir file due to file traversal: " + relativePath, (Throwable)e);
            return ExceptionUtils.toResponse((String)"fileTraversalDetected", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error creating parent directories for file: " + filePath, (Throwable)e);
        }
        LOGGER.info("UserDataDir received request to upload file " + relativePath + ", created: " + createdTime + ", lastModifiedTime: " + lastModifiedTime);
        if (Files.exists(filePath, new LinkOption[0])) {
            BasicFileAttributes attr = null;
            try {
                attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                fileInfo = new FileInfo();
                fileInfo.setRelativePath(this.userDataDirPath.relativize(filePath).toString());
                long existingFileLastModifiedTime = attr.lastModifiedTime().toMillis();
                long existingFileCreatedTime = attr.creationTime().toMillis();
                fileInfo.setLastModifiedTime(existingFileLastModifiedTime);
                fileInfo.setCreatedTime(existingFileCreatedTime);
                LOGGER.info("UserDataDir file " + relativePath + " exists, createad: " + existingFileCreatedTime + ", lastModifiedTime: " + existingFileLastModifiedTime);
                if (existingFileLastModifiedTime == createdTime && existingFileCreatedTime == lastModifiedTime) {
                    LOGGER.info("Skipping UserDataDir file " + relativePath + " because it already exists with the same dates");
                    return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)fileInfo).build();
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot get file " + filePath + " properties", (Throwable)e);
            }
        }
        try {
            Files.copy((InputStream)request.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Error uploading file", (Throwable)e);
            return ExceptionUtils.toResponse((String)"errorReadingFileData", (Response.Status)Response.Status.BAD_REQUEST);
        }
        BasicFileAttributeView attributes = Files.getFileAttributeView(filePath, BasicFileAttributeView.class, new LinkOption[0]);
        try {
            attributes.setTimes(FileTime.fromMillis(lastModifiedTime), FileTime.fromMillis(lastModifiedTime), FileTime.fromMillis(createdTime));
        }
        catch (IOException e) {
            LOGGER.error("Cannot set file timestamps", (Throwable)e);
        }
        fileInfo = new FileInfo();
        fileInfo.setRelativePath(this.userDataDirPath.relativize(filePath).toString());
        fileInfo.setLastModifiedTime(lastModifiedTime);
        fileInfo.setCreatedTime(createdTime);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)fileInfo).build();
    }

    @Path(value="/files:batchDelete")
    @POST
    @Consumes(value={"application/json"})
    public Response deleteUserDataDirFiles(@Auth BearerUser user, Set<String> relativePaths) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return ExceptionUtils.toResponse((String)"userNotAllowedToUseApi", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        for (String relativePath : relativePaths) {
            try {
                java.nio.file.Path filePath = FileUtils.safeResolveParent((java.nio.file.Path)this.userDataDirPath, (String[])new String[]{relativePath});
                FileUtils.deleteRecursively((java.nio.file.Path)filePath);
            }
            catch (FileTraversalException e) {
                LOGGER.error("Error deleting userDataDir file due to file traversal: " + relativePath, (Throwable)e);
                return ExceptionUtils.toResponse((String)"fileTraversalDetected", (Response.Status)Response.Status.BAD_REQUEST);
            }
            catch (IOException e) {
                LOGGER.error("Error deleting userDataDir file: " + relativePath, (Throwable)e);
            }
        }
        try {
            FileUtils.deleteAllEmptyDirectories((java.nio.file.Path)this.userDataDirPath, (boolean)false);
        }
        catch (IOException e) {
            LOGGER.error("Error deleting emptyDirs", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private Map<String, FileInfo> buildUserDataDirFileInfos() throws IOException {
        final HashMap<String, FileInfo> fileInfoMap = new HashMap<String, FileInfo>();
        Files.walkFileTree(this.userDataDirPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            @Override
            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                if (attrs.isSymbolicLink() || attrs.isOther()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setRelativePath(UserDataDirResource.this.userDataDirPath.relativize(file).toString());
                BasicFileAttributes fileAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                fileInfo.setCreatedTime(fileAttributes.creationTime().toMillis());
                fileInfo.setLastModifiedTime(fileAttributes.lastModifiedTime().toMillis());
                fileInfoMap.put(fileInfo.getRelativePath(), fileInfo);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) {
                LOGGER.error("Error handling file: " + file, (Throwable)exc);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return fileInfoMap;
    }
}

