/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.OperationUtilizationModel;
import io.dropwizard.auth.Auth;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/server/utilization")
@Produces(value={"application/json"})
public class UtilizationResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilizationResource.class);
    private ServerApplication serverApplication;
    private ServerConfiguration serverConfiguration;
    private Map<String, OperationUtilizationModel> utilizationMap;

    public UtilizationResource(ServerApplication serverApplication) {
        this.serverApplication = serverApplication;
        this.utilizationMap = new ConcurrentHashMap<String, OperationUtilizationModel>();
    }

    @GET
    public Response getUtilizations(@Auth BearerUser user) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(this.utilizationMap.values()).build();
    }

    public void addUtilization(OperationUtilizationModel operationUtilizationModel) {
        this.utilizationMap.put(operationUtilizationModel.getUtilizationId(), operationUtilizationModel);
    }

    @DELETE
    @Path(value="/{id}")
    public Response removeUtilization(@Auth BearerUser user, @PathParam(value="id") String id) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.utilizationMap.remove(id);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("utilizationRemoved")).build();
    }
}

