/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.security.bearer;

import com.nuix.automate.dropwizard.utils.security.bearer.ApiBearerUser;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.general.HashingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class BearerAuthenticator
implements Authenticator<String, BearerUser> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BearerAuthenticator.class);
    private final ServerApplication serverApplication;
    private final ServerConfiguration serverConfiguration;
    private Map<String, BearerUser> apiUserToToken;

    public BearerAuthenticator(ServerApplication serverApplication, ServerConfiguration serverConfiguration) {
        this.serverApplication = serverApplication;
        this.serverConfiguration = serverConfiguration;
        this.apiUserToToken = new ConcurrentHashMap<String, BearerUser>();
    }

    public String getTokenFromApiSecret() {
        return this.getTokenFromApiSecret(this.serverApplication.getInstanceId());
    }

    public String getTokenFromApiSecret(String instanceId) {
        String plaintext = instanceId + this.serverConfiguration.getApiSecret();
        return HashingUtils.digestAsHex((String)plaintext);
    }

    public String getTokenFromApiSecret(String instanceId, String nonce) {
        String plaintext = nonce + instanceId + this.serverConfiguration.getApiSecret();
        return HashingUtils.digestAsHex((String)plaintext);
    }

    public Optional<BearerUser> authenticate(String token) throws AuthenticationException {
        ApiBearerUser user = null;
        if (token.equals(this.getTokenFromApiSecret())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Token is for SSO authentication");
            }
            user = new ApiBearerUser();
        }
        if (user == null) {
            return Optional.empty();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User session is valid: " + user.toString());
        }
        return Optional.of(user);
    }
}

