/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.server.workers;

import com.nuix.automate.server.ServerApplication;
import com.nuix.automate.server.ServerConfiguration;
import com.nuix.automate.utils.general.NetworkUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class ServerWorker {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerWorker.class);
    private transient Registry registry;
    private ServerApplication serverApplication;
    private ServerConfiguration serverConfiguration;

    public ServerWorker(ServerApplication serverApplication) throws RemoteException, AlreadyBoundException {
        this.serverApplication = serverApplication;
        this.serverConfiguration = serverApplication.getConfiguration();
        int port = this.serverConfiguration.getServerLocalPort();
        if (port == 0) {
            try {
                port = NetworkUtils.getAvailablePort();
            }
            catch (IOException e) {
                port = NetworkUtils.getRandomPort();
            }
        }
        int attempts = 0;
        while (attempts < 50) {
            try {
                LOGGER.info("Creating registry on port " + port);
                this.registry = LocateRegistry.createRegistry(port);
                this.serverConfiguration.setServerLocalPort(port);
                break;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot create registry", (Throwable)e);
                port = NetworkUtils.getRandomPort();
            }
        }
        if (this.registry == null) {
            throw new RemoteException("Cannot create registry");
        }
        LOGGER.info("Waiting for engines");
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

