/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.api.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.security.SecurityUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Status
implements Cloneable,
Serializable {
    @Schema(description="Status Message", example="The object is encountering errors and cannot continue\n java.lang.Exception: Stack trace\nat java.base/java.lang.Thread.dumpStack(Thread.java:1383)\nat com.sample.example.StackTrace.d(StackTrace.java:23)")
    private String message;
    @Schema(description="Short Status Message", example="The object is encountering errors")
    private String shortMessage;
    @Schema(description="Status Code")
    private State code;
    @Schema(description="Last Updated Date (Epoch)", example="1641034800000")
    private long lastUpdatedDate;

    public Status() {
        this.reset();
    }

    public Status clone() {
        Status clonedObject = null;
        try {
            clonedObject = (Status)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clonedObject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setError(String message) {
        this.setError(message, message);
    }

    public synchronized void setError(String message, String shortMessage) {
        this.message = message;
        this.shortMessage = shortMessage;
        this.code = State.ERROR;
        this.setLastUpdatedDate();
    }

    public void setErrorIfNotError(String message) {
        this.setErrorIfNotError(message, message);
    }

    public synchronized void setErrorIfNotError(String message, String shortMessage) {
        if (!this.code.equals((Object)State.ERROR)) {
            this.message = message;
            this.shortMessage = shortMessage;
            this.code = State.ERROR;
            this.setLastUpdatedDate();
        }
    }

    @JsonIgnore
    public void setOrAppendError(String message) {
        this.setOrAppendError(message, message);
    }

    @JsonIgnore
    public synchronized void setOrAppendError(String message, String shortMessage) {
        if (this.code != State.ERROR) {
            this.message = message;
            this.shortMessage = shortMessage;
        } else {
            if (!this.message.contains(message)) {
                if (this.message.length() > 0) {
                    this.message = this.message + "\n";
                }
                this.message = this.message + message;
            }
            if (!this.shortMessage.contains(shortMessage)) {
                if (this.shortMessage.length() > 0) {
                    this.shortMessage = this.shortMessage + ", ";
                }
                this.shortMessage = this.shortMessage + shortMessage;
            }
        }
        this.code = State.ERROR;
        this.setLastUpdatedDate();
    }

    @JsonIgnore
    public void setWarningMessage(String warningMessage) {
        this.setWarningMessage(warningMessage, warningMessage);
    }

    @JsonIgnore
    public synchronized void setWarningMessage(String message, String shortMessage) {
        if (this.code != State.ERROR) {
            this.code = State.WARNING;
            this.message = message;
            this.shortMessage = shortMessage;
        } else {
            if (!this.message.contains(message)) {
                if (this.message.length() > 0) {
                    this.message = this.message + "\n";
                }
                this.message = this.message + message;
            }
            if (!this.shortMessage.contains(shortMessage)) {
                if (this.shortMessage.length() > 0) {
                    this.shortMessage = this.shortMessage + ", ";
                }
                this.shortMessage = this.shortMessage + shortMessage;
            }
        }
        this.setLastUpdatedDate();
    }

    public State getCode() {
        return this.code;
    }

    public synchronized void setCode(State code) {
        this.code = code;
    }

    @JsonIgnore
    public void setInfoMessage(String infoMessage) {
        this.setInfoMessage(infoMessage, infoMessage);
    }

    @JsonIgnore
    public synchronized void setInfoMessage(String infoMessage, String shortMessage) {
        if (this.code != State.ERROR && this.code != State.WARNING) {
            this.code = State.INFO;
            this.message = infoMessage;
            this.shortMessage = shortMessage;
        } else {
            this.message = this.message + "\n" + infoMessage;
            this.shortMessage = this.shortMessage + ", " + shortMessage;
        }
        this.setLastUpdatedDate();
    }

    public void resetOk() {
        this.resetOkMessage(null, null);
    }

    public synchronized void resetOkMessage(String message) {
        this.resetOkMessage(message, message);
    }

    public void resetOkMessage(String message, String shortMessage) {
        this.message = message;
        this.shortMessage = shortMessage;
        this.code = State.OK;
        this.setLastUpdatedDate();
    }

    public void reset() {
        this.code = State.UNKNOWN;
        this.message = null;
        this.shortMessage = null;
        this.setLastUpdatedDate();
    }

    public long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    private void setLastUpdatedDate() {
        this.lastUpdatedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public Status cloneLimited() {
        Status limited = new Status();
        if (this.code == null) {
            this.code = State.UNKNOWN;
        }
        limited.code = this.code;
        limited.lastUpdatedDate = this.lastUpdatedDate;
        if (this.code.equals((Object)State.OK)) {
            // empty if block
        }
        if (this.code.equals((Object)State.INFO)) {
            limited.message = this.message;
            limited.shortMessage = this.shortMessage;
        } else {
            if (this.message != null && this.message.length() > 0) {
                limited.message = FormattingUtils.constantToCamelCaseFirstUpper(limited.code.name()) + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.message);
            }
            if (this.shortMessage != null && this.shortMessage.length() > 0) {
                limited.shortMessage = FormattingUtils.constantToCamelCaseFirstUpper(limited.code.name()) + " Code " + SecurityUtils.computeShortSha256Hex("Short message" + this.shortMessage);
            }
        }
        return limited;
    }
}

