/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.api.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.general.SerializationUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Map;

public class TranslationResponseStatus
extends ResponseStatus
implements Serializable {
    @Schema(description="Response Key", example="sampleKey")
    private String key;
    @Schema(description="Response Values", ref="#/components/schemas/ExceptionValues")
    private Map<String, String> values;

    public TranslationResponseStatus() {
    }

    public TranslationResponseStatus(String key) {
        this.key = key;
    }

    public TranslationResponseStatus(String key, Map<String, String> values) {
        this.key = key;
        this.values = values;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, String> getValues() {
        return this.values;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValues(Map<String, String> values) {
        this.values = values;
    }

    @Override
    public String toString() {
        String response = this.key;
        if (this.values != null && this.values.size() > 0) {
            response = response + " " + SerializationUtils.toJson(this.values);
        }
        return response;
    }
}

