/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.api.script;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.nuix.automate.utils.api.script.RestException;
import java.lang.reflect.Type;
import java.util.Map;

public class Response {
    private Gson gson;
    private String url;
    private String reason;
    public final int status_code;
    public final String text;
    public final byte[] raw;
    public final Map<String, String> headers;

    public Response(int status_code, String reason, String text, byte[] raw, Map<String, String> headers, String url) {
        this.status_code = status_code;
        this.reason = reason;
        this.text = text;
        this.raw = raw;
        this.headers = headers;
        this.url = url;
        this.gson = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    }

    public Object json() {
        return this.gson.fromJson(this.text, Object.class);
    }

    public <T> T getObject(Class<T> classOfT) {
        return (T)this.gson.fromJson(this.text, classOfT);
    }

    public <T> T getObject(Type type) {
        return (T)this.gson.fromJson(this.text, type);
    }

    public void raise_for_status() throws RestException {
        if (this.status_code >= 400 && this.status_code < 500) {
            throw new RestException(this.status_code + " Client Error: " + this.reason + " for url " + this.url);
        }
        if (this.status_code >= 500 && this.status_code < 600) {
            throw new RestException(this.status_code + " Server Error: " + this.reason + " for url " + this.url);
        }
    }

    public String toString() {
        return "<Response [" + this.status_code + "]>";
    }
}

