/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.azure;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import reactor.core.publisher.Mono;

public class AzureNoRetryPolicy
extends RetryPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(RetryPolicy.class);

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest originalHttpRequest = context.getHttpRequest();
        BinaryData originalRequestBody = originalHttpRequest.getBodyAsBinaryData();
        return originalRequestBody != null && !originalRequestBody.isReplayable() ? originalRequestBody.toReplayableBinaryDataAsync().flatMap(replayableBody -> {
            context.getHttpRequest().setBody(replayableBody);
            return this.attemptAsync(context, next, originalHttpRequest);
        }) : this.attemptAsync(context, next, originalHttpRequest);
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpRequest originalHttpRequest = context.getHttpRequest();
        BinaryData originalRequestBody = originalHttpRequest.getBodyAsBinaryData();
        if (originalRequestBody != null && !originalRequestBody.isReplayable()) {
            context.getHttpRequest().setBody(context.getHttpRequest().getBodyAsBinaryData().toReplayableBinaryData());
        }
        return this.attemptSync(context, next, originalHttpRequest);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext context, HttpPipelineNextPolicy next, HttpRequest originalHttpRequest) {
        context.setHttpRequest(originalHttpRequest.copy());
        return next.clone().process().flatMap(Mono::just).onErrorResume(Exception.class, Mono::error);
    }

    private HttpResponse attemptSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next, HttpRequest originalHttpRequest) {
        HttpResponse httpResponse;
        try {
            context.setHttpRequest(originalHttpRequest.copy());
            httpResponse = next.clone().processSync();
        }
        catch (RuntimeException var11) {
            throw LOGGER.logExceptionAsError(var11);
        }
        return httpResponse;
    }
}

