/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.ecc.internal;

import com.nuix.automate.utils.ecc.internal.EccIdentifierType;
import com.nuix.automate.utils.ecc.internal.FilterableEcc;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.workflow.ParameterType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EccUtils {
    private InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static EccUtils instance;

    public static EccUtils getInstance() {
        if (instance == null) {
            instance = new EccUtils();
        }
        return instance;
    }

    public boolean isEccParameter(ParameterType parameterType) {
        return parameterType == ParameterType.ECC_COMPUTER || parameterType == ParameterType.ECC_CONFIGURATION;
    }

    public List<Computer> filterAllComputers(Collection<Computer> computers, EccIdentifierType identifierType, String identifier) throws IOException {
        ArrayList<Computer> computersList = new ArrayList<Computer>(computers);
        return this.filterAllComputers((List<Computer>)computersList, identifierType, identifier);
    }

    public List<Computer> filterAllComputers(List<Computer> computers, EccIdentifierType identifierType, String identifier) throws IOException {
        ArrayList<Computer> matches = new ArrayList<Computer>();
        switch (identifierType) {
            case ID: {
                for (Computer computer : computers) {
                    int eccId = 0;
                    try {
                        eccId = Integer.parseInt(identifier);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(this.iu.getFormattedString("Ecc.Exception.IncorrectId", (Object)computer.getTypeName()));
                    }
                    if (computer.getId() != eccId) continue;
                    matches.add(computer);
                    return matches;
                }
                return null;
            }
            case NAME: {
                for (Computer computer : computers) {
                    if (!computer.getName().equals(identifier)) continue;
                    matches.add(computer);
                }
                return matches.size() >= 1 ? matches : null;
            }
            case NAME_REGEX: {
                for (Computer computer : computers) {
                    if (!computer.getName().matches(identifier)) continue;
                    matches.add(computer);
                }
                return matches.size() >= 1 ? matches : null;
            }
        }
        return null;
    }

    public <T extends FilterableEcc> T filter(Collection<T> objects, EccIdentifierType identifierType, String identifier) throws IOException {
        ArrayList<T> objectList = new ArrayList<T>(objects);
        return this.filter((List<T>)objectList, identifierType, identifier);
    }

    public <T extends FilterableEcc> T filter(List<T> objects, EccIdentifierType identifierType, String identifier) throws IOException {
        ArrayList<FilterableEcc> matches = new ArrayList<FilterableEcc>();
        String typeName = "unknown";
        if (objects.size() > 0) {
            typeName = ((FilterableEcc)objects.get(0)).getTypeName();
        }
        switch (identifierType) {
            case ID: {
                for (FilterableEcc filterableObject : objects) {
                    int eccId = 0;
                    try {
                        eccId = Integer.parseInt(identifier);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(this.iu.getFormattedString("Ecc.Exception.IncorrectId", (Object)typeName));
                    }
                    if (filterableObject.getId() != eccId) continue;
                    return (T)filterableObject;
                }
                return null;
            }
            case NAME: {
                for (FilterableEcc filterableObject : objects) {
                    if (!filterableObject.getName().equals(identifier)) continue;
                    matches.add(filterableObject);
                }
                if (matches.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Ecc.Exception.MultipleNamesMatches", matches.size(), typeName, identifier));
                }
                return (T)(matches.size() == 1 ? (FilterableEcc)matches.get(0) : null);
            }
            case NAME_REGEX: {
                for (FilterableEcc filterableObject : objects) {
                    if (!filterableObject.getName().matches(identifier)) continue;
                    matches.add(filterableObject);
                }
                if (matches.size() > 1) {
                    throw new IOException(this.iu.getFormattedString("Ecc.Exception.MultipleRegexMatches", matches.size(), typeName, identifier));
                }
                return (T)(matches.size() == 1 ? (FilterableEcc)matches.get(0) : null);
            }
        }
        return null;
    }

    public <T extends FilterableEcc> boolean containsName(List<T> objects, String name) {
        for (FilterableEcc filterableObject : objects) {
            if (!filterableObject.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

