/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public final class CommandLineUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CommandLineUtils.class);
    public static File NULL_FILE = new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null");

    public static File getJarFile() throws UnsupportedEncodingException {
        String path = CommandLineUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(path.replace("+", "%2B"), "UTF-8");
        return new File(decodedPath);
    }

    public static Map<String, String> extractCommandLineArguments(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : args) {
            String value;
            String key;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Parsing\t" + arg);
            }
            if ((arg = arg.trim()).startsWith("\"") && arg.endsWith("\"")) {
                arg = arg.replace("\\\"", "\"");
                arg = arg.substring(1, arg.length() - 2);
            }
            if (!arg.startsWith("-D")) continue;
            int indexOfEquals = (arg = arg.substring(2)).indexOf(61);
            if (indexOfEquals > 0) {
                key = arg.substring(0, indexOfEquals);
                value = arg.substring(indexOfEquals + 1);
            } else {
                key = arg;
                value = "";
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.replace("\\\"", "\"");
                value = value.substring(1, value.length() - 2);
            }
            result.put(key, value);
        }
        return result;
    }
}

