/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.api.script.RestException;
import com.nuix.automate.utils.api.script.RestSSLException;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.policies.UnauthorizedException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ExceptionUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExceptionUtils.class);

    public static boolean isCausedByInterrupt(Throwable e) {
        if (e instanceof InterruptedException) {
            return true;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            return ExceptionUtils.isCausedByInterrupt(cause);
        }
        return false;
    }

    public static String getExceptionPrintableMessage(Throwable t) {
        return ExceptionUtils.getExceptionPrintableMessage(t, false);
    }

    public static String getExceptionPrintableMessage(Throwable t, boolean printExceptionName) {
        String message = "";
        if (!printExceptionName && t.getClass().equals(ScriptException.class) && t.getCause() != null && t.getCause().getCause() != null && (t.getCause().getCause().getClass().equals(RestException.class) || t.getCause().getCause().getClass().equals(RestSSLException.class))) {
            t = t.getCause().getCause();
        }
        do {
            try {
                String additionalMessage = "";
                if (t == null || t instanceof NullPointerException) {
                    StackTraceElement[] stackTrace = null;
                    if (t != null) {
                        stackTrace = t.getStackTrace();
                    }
                    additionalMessage = stackTrace != null && stackTrace.length > 0 ? t.getClass().getSimpleName() + " in " + stackTrace[0].getClassName() + "." + stackTrace[0].getMethodName() + "()#" + stackTrace[0].getLineNumber() : "NullPointerException";
                } else {
                    StackTraceElement[] stackTrace;
                    if (printExceptionName) {
                        additionalMessage = t.getClass().getSimpleName() + ": ";
                    } else {
                        String whiteListedExceptionNamePrefix = "java.nio.file.";
                        String exceptionName = t.getClass().getName();
                        if (exceptionName.startsWith(whiteListedExceptionNamePrefix)) {
                            exceptionName = exceptionName.substring(whiteListedExceptionNamePrefix.length());
                            additionalMessage = exceptionName + ": ";
                        }
                    }
                    String exceptionPrintableMessage = t.getLocalizedMessage();
                    if (t instanceof ResponseException) {
                        try {
                            ResponseException responseException = (ResponseException)t;
                            Object responseEntity = responseException.getResponse().getEntity();
                            if (responseEntity instanceof TranslationResponseStatus) {
                                TranslationResponseStatus translationResponseStatus = (TranslationResponseStatus)responseEntity;
                                String exceptionValue = translationResponseStatus.getValues().get("exception");
                                if (exceptionValue != null) {
                                    exceptionPrintableMessage = exceptionValue;
                                }
                            } else {
                                exceptionPrintableMessage = responseEntity.toString();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("Cannot get response exception message");
                        }
                    }
                    additionalMessage = exceptionPrintableMessage != null ? additionalMessage + exceptionPrintableMessage : ((stackTrace = t.getStackTrace()) != null && stackTrace.length > 0 ? additionalMessage + "NullPointerException in " + stackTrace[0].getClassName() + " " + stackTrace[0].getMethodName() + "() line " + stackTrace[0].getLineNumber() : additionalMessage + "NullPointerException");
                }
                if (additionalMessage.contains(message)) {
                    message = additionalMessage;
                } else if (!message.contains(additionalMessage) && message.length() > 0) {
                    message = message + ", ";
                    message = message + additionalMessage;
                }
                if (t != null) {
                    t = t.getCause();
                }
                if (t != null) continue;
            }
            catch (Throwable t2) {
                LOGGER.error("Cannot get exception message", t2);
            }
            break;
        } while (!(t instanceof ScriptException) || printExceptionName);
        if (message.length() > 1000) {
            return message.substring(0, 1000) + "...";
        }
        message = message.replace(". ,", ", ");
        message = message.replace(".,", ", ");
        return message;
    }

    public static String getStackTrace(Throwable t) {
        return org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace((Throwable)t);
    }

    private static String mapToString(Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            for (String key : values.keySet()) {
                sb.append(", ");
                sb.append(key + ": " + values.get(key));
            }
        }
        return sb.toString();
    }

    public static Response toResponse(String key) {
        return ExceptionUtils.toResponse(key, (Map<String, String>)null);
    }

    public static Response toResponse(String key, Map<String, String> values) {
        LOGGER.error("Error Key: " + key + ExceptionUtils.mapToString(values));
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(key, values)).build();
    }

    public static Response toUnauthenticatedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
    }

    public static void logUserDoesNotHavePermissions(String user, Object object) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        LOGGER.warn("User " + user + " unauthorized to " + stackTraceElements[2].getMethodName() + " on " + object.getClass().getSimpleName() + " " + SerializationUtils.toJson(object), new UnauthorizedException());
    }

    public static Response buildForbiddenResponse(String user, Object object) {
        ExceptionUtils.logUserDoesNotHavePermissions(user, object);
        return ExceptionUtils.buildForbiddenResponse();
    }

    public static Response buildForbiddenResponse() {
        return ExceptionUtils.toResponse("userDoesNotHavePermissions", Response.Status.FORBIDDEN);
    }

    public static Response toResponse(String key, Response.Status status) {
        return ExceptionUtils.toResponse(key, (Map<String, String>)null, status);
    }

    public static Response toResponse(String key, Map<String, String> values, Response.Status status) {
        LOGGER.error("Error Key: " + key + ExceptionUtils.mapToString(values));
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(key, values)).build();
    }

    public static Response toResponse(String key, Map<String, String> values, Exception e) {
        LOGGER.error("Error Key: " + key + ExceptionUtils.mapToString(values), e);
        values = values == null ? new HashMap<String, String>() : values;
        values.put("exception", ExceptionUtils.getExceptionPrintableMessage(e));
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(key, values)).build();
    }

    public static Response toResponse(String key, Exception e) {
        return ExceptionUtils.toResponse(key, e, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static Response toResponse(String key, Exception e, Response.Status status) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("exception", ExceptionUtils.getExceptionPrintableMessage(e, true));
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(key, values)).build();
    }

    public static Response toResponse(String key, Map<String, String> values, Exception e, Response.Status status) {
        LOGGER.error("Error Key: " + key + ExceptionUtils.mapToString(values), e);
        values = values == null ? new HashMap<String, String>() : values;
        values.put("exception", ExceptionUtils.getExceptionPrintableMessage(e));
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(key, values)).build();
    }

    public static Object fromResponse(Response response) {
        Object responseEntity = response.getEntity();
        if (responseEntity instanceof TranslationResponseStatus) {
            return responseEntity;
        }
        if (responseEntity instanceof ResponseStatus) {
            ResponseStatus responseStatus = (ResponseStatus)responseEntity;
            String message = "";
            if (responseStatus.getTitle() != null) {
                message = responseStatus.getTitle() + ": ";
            }
            message = message + responseStatus.getMessage();
            return message;
        }
        return response.getStatusInfo().getReasonPhrase();
    }
}

