/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.workflow.Parameter;
import com.nuix.automate.utils.workflow.ParameterType;
import java.io.Serializable;

public class ExecutionParameter
implements Serializable,
Cloneable {
    private String name;
    private String friendlyName;
    private ParameterType type;
    private String value;

    public ExecutionParameter(String name, String friendlyName, ParameterType type, String value) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.type = type;
        this.value = value;
    }

    public ExecutionParameter(Parameter o, int maxSize) {
        this.name = o.getName();
        this.friendlyName = o.getFriendlyName();
        this.type = o.getEffectiveParameterType();
        this.value = "";
        try {
            this.value = o.getMaskedValue();
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        if (this.value.length() > maxSize) {
            this.value = this.value.substring(0, maxSize) + "...";
        }
    }

    public ExecutionParameter() {
    }

    protected ExecutionParameter clone() throws CloneNotSupportedException {
        try {
            return (ExecutionParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

