/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class FileLibraryUtils {
    private static FileLibraryUtils instance;

    public static FileLibraryUtils getInstance() {
        if (instance == null) {
            instance = new FileLibraryUtils();
        }
        return instance;
    }

    public LibraryNuixFileType getNuixFileType(FileLibraryFile libraryFile) {
        try {
            String fileData;
            String[] lines;
            LibraryNuixFileType fileType;
            if ((libraryFile.getName().toLowerCase().endsWith(".profile") || libraryFile.getName().toLowerCase().endsWith(".xml") || libraryFile.getName().toLowerCase().endsWith(".npf")) && (fileType = this.parseNuixFileTypeFromFileLines(lines = (fileData = new String(Base64.getDecoder().decode(libraryFile.getData()), StandardCharsets.UTF_8)).split("\n"))) != null) {
                return fileType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (libraryFile.getName().toLowerCase().endsWith(".py")) {
            return LibraryNuixFileType.PYTHON_SCRIPT;
        }
        if (libraryFile.getName().toLowerCase().endsWith(".rb")) {
            return LibraryNuixFileType.RUBY_SCRIPT;
        }
        if (libraryFile.getName().toLowerCase().endsWith(".js")) {
            return LibraryNuixFileType.JS_SCRIPT;
        }
        if (libraryFile.getName().toLowerCase().endsWith(".ps1")) {
            return LibraryNuixFileType.POWERSHELL_SCRIPT;
        }
        return LibraryNuixFileType.CUSTOM_FILE;
    }

    public boolean isSameFile(FileLibraryFile a, FileLibraryFile b) {
        return Objects.equals(a.getName(), b.getName()) && Objects.equals(a.getData(), b.getData());
    }

    public boolean isScriptedFile(FileLibraryFile file) {
        LibraryNuixFileType type = file.getNuixFileType();
        return type == LibraryNuixFileType.PYTHON_SCRIPT || type == LibraryNuixFileType.RUBY_SCRIPT || type == LibraryNuixFileType.JS_SCRIPT || type == LibraryNuixFileType.POWERSHELL_SCRIPT;
    }

    public LibraryNuixFileType parseNuixFileTypeFromFileLines(String[] lines) {
        return this.parseNuixFileTypeFromFileLines(lines, null);
    }

    public LibraryNuixFileType parseNuixFileTypeFromFileLines(String[] lines, LibraryNuixFileType expectedType) {
        for (int i = 0; i < lines.length && i < 6; ++i) {
            String xmlTag;
            LibraryNuixFileType fileType;
            if (lines[i] == null || (fileType = this.parseNuixFileTypeFromXmlTag(xmlTag = lines[i].trim().split(" ")[0])) == null || expectedType != null && fileType != expectedType) continue;
            return fileType;
        }
        return null;
    }

    public LibraryNuixFileType parseNuixFileTypeFromXmlTag(String tag) {
        switch (tag.toLowerCase()) {
            case "<processing-profile": {
                return LibraryNuixFileType.PROCESSING_PROFILE;
            }
            case "<metadata-profile": {
                return LibraryNuixFileType.METADATA_PROFILE;
            }
            case "<metadata-import-profile": {
                return LibraryNuixFileType.METADATA_IMPORT_PROFILE;
            }
            case "playbook:": {
                return LibraryNuixFileType.PLAYBOOK;
            }
            case "<ocr-profile": {
                return LibraryNuixFileType.OCR_PROFILE;
            }
            case "<production-profile": {
                return LibraryNuixFileType.PRODUCTION_PROFILE;
            }
            case "<preferences": {
                return LibraryNuixFileType.CONFIGURATION_PROFILE;
            }
            case "<imaging-profile": {
                return LibraryNuixFileType.IMAGING_PROFILE;
            }
        }
        return null;
    }

    public String getExtension(LibraryNuixFileType type) {
        switch (type) {
            case CONFIGURATION_PROFILE: {
                return ".npf";
            }
            case METADATA_PROFILE: {
                return ".profile";
            }
            case METADATA_IMPORT_PROFILE: 
            case OCR_PROFILE: 
            case IMAGING_PROFILE: 
            case PROCESSING_PROFILE: 
            case PRODUCTION_PROFILE: {
                return ".xml";
            }
            case PLAYBOOK: {
                return ".yml";
            }
        }
        return "";
    }
}

