/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import org.joda.time.DateTime;

public final class FrequentLogUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FrequentLogUtils.class);
    private static Long lastLogEpoch;

    public static void resetLastTimestamp() {
        lastLogEpoch = null;
    }

    public static synchronized void resetInfo(String message) {
        FrequentLogUtils.resetLastTimestamp();
        FrequentLogUtils.info(message, 1000L);
    }

    public static synchronized void info(String message) {
        FrequentLogUtils.info(message, 1000L);
    }

    public static synchronized void info(String message, long frequency) {
        long nowEpoch = DateTime.now().getMillis();
        if (lastLogEpoch == null || nowEpoch - lastLogEpoch > frequency) {
            LOGGER.info(message);
            lastLogEpoch = nowEpoch;
        }
    }
}

