/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.UIManager;

public class IconUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(IconUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImageIcon(String extension, boolean getLargeIcon) {
        Icon icon = null;
        File tempFile = null;
        boolean isDirectory = extension.equalsIgnoreCase("directory");
        try {
            tempFile = isDirectory ? Files.createTempDirectory("temp" + System.nanoTime(), new FileAttribute[0]).toFile() : FileUtils.createTempFile("temp" + System.nanoTime(), "." + extension);
            icon = IconUtils.getSystemIcon(tempFile, getLargeIcon);
            if (icon != null) {
                BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g = image.createGraphics();
                icon.paintIcon(null, g, 0, 0);
                g.dispose();
                BufferedImage bufferedImage = image;
                return bufferedImage;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Cannot get system icon for extension: " + extension, e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        try {
            InputStream iconStream = IconUtils.class.getResourceAsStream("/icons/extension/" + (getLargeIcon ? "large" : "small") + "/" + extension + ".png");
            return ImageIO.read(iconStream);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.warn("Cannot get stored icon for extension: " + extension + ", " + ExceptionUtils.getExceptionPrintableMessage(e));
            try {
                InputStream iconStream = IconUtils.class.getResourceAsStream("/icons/extension/" + (getLargeIcon ? "large" : "small") + "/_file.png");
                return ImageIO.read(iconStream);
            }
            catch (IOException | IllegalArgumentException e2) {
                LOGGER.warn("Cannot get stored icon for extension: unknown, " + ExceptionUtils.getExceptionPrintableMessage(e2));
                icon = UIManager.getIcon(isDirectory ? "FileView.directoryIcon" : "FileView.fileIcon");
                BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D g = image.createGraphics();
                icon.paintIcon(null, g, 0, 0);
                g.dispose();
                return image;
            }
        }
    }

    private static Icon getSystemIcon(File f, boolean getLargeIcon) throws Exception {
        return null;
    }
}

