/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class InternationalizationUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(InternationalizationUtils.class);
    private static final Map<String, InternationalizationUtils> instances = new HashMap<String, InternationalizationUtils>();
    private final Set<String> keysMissingFromBundle;
    ResourceBundle resourceBundle;
    Locale locale;
    Map<String, String> languagesCountriesLocales = new HashMap<String, String>();

    public static InternationalizationUtils getInstance(String baseName) {
        return InternationalizationUtils.getInstance(baseName, Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternationalizationUtils getInstance(String baseName, Locale locale) {
        String key = baseName + locale.toString();
        Map<String, InternationalizationUtils> map = instances;
        synchronized (map) {
            InternationalizationUtils instance = instances.get(key);
            if (instance == null) {
                instance = new InternationalizationUtils(baseName, locale);
                instances.put(key, instance);
            }
            return instance;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalName() {
        return this.locale.getLanguage() + "_" + this.locale.getCountry();
    }

    public static Map<String, InternationalizationUtils> getInstances() {
        return instances;
    }

    public Set<String> getKeysMissingFromBundle() {
        return this.keysMissingFromBundle;
    }

    private InternationalizationUtils(String baseName, Locale locale) {
        this.languagesCountriesLocales.put("ar", "AE");
        this.languagesCountriesLocales.put("da", "DK");
        this.languagesCountriesLocales.put("de", "DE");
        this.languagesCountriesLocales.put("en", "US");
        this.languagesCountriesLocales.put("es", "419");
        this.languagesCountriesLocales.put("fr", "CA");
        this.languagesCountriesLocales.put("he", "IL");
        this.languagesCountriesLocales.put("ja", "JP");
        this.languagesCountriesLocales.put("ko", "KR");
        this.languagesCountriesLocales.put("nl", "NL");
        this.languagesCountriesLocales.put("pt", "BR");
        this.languagesCountriesLocales.put("zh", "CN");
        this.locale = locale;
        this.resourceBundle = this.getBundle("internationalization/" + baseName);
        this.keysMissingFromBundle = new HashSet<String>();
    }

    public String getString(String key) {
        return this.getString(key, false);
    }

    public String getString(String key, boolean silent) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            boolean newElement = this.keysMissingFromBundle.add(key);
            if (newElement && !silent) {
                try {
                    throw new IllegalArgumentException("Cannot find key " + key + " in locale " + this.locale);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.warn("Missing key", ex);
                }
            }
            return key;
        }
    }

    public String getNumeralString(String key, long numeral) {
        if (numeral == 0L) {
            return this.getFormattedString(key + "0", (Object)numeral);
        }
        if (numeral == 1L) {
            return this.getFormattedString(key + "1", (Object)numeral);
        }
        return this.getFormattedString(key + "2", (Object)numeral);
    }

    public String getNumeralFormattedString(String key, long numeral, Object value) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.applyPattern(this.getNumeralString(key, numeral));
        return messageFormat.format(new Object[]{numeral, value});
    }

    public String getNumeralFormattedString(String key, long numeral, Object ... values) {
        MessageFormat messageFormat = new MessageFormat("");
        ArrayList<Object> valuesList = new ArrayList<Object>();
        valuesList.add(numeral);
        valuesList.addAll(Arrays.asList(values));
        messageFormat.applyPattern(this.getNumeralString(key, numeral));
        return messageFormat.format(valuesList.toArray());
    }

    public String getFormattedString(String key, Object value) {
        return this.getFormattedString(key, new Object[]{value});
    }

    public String getFormattedString(String key, Object ... values) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.applyPattern(this.getString(key));
        return messageFormat.format(values);
    }

    private boolean isResourceBundleValid(ResourceBundle testResourceBundle) {
        return testResourceBundle != null && testResourceBundle.getLocale() != null && testResourceBundle.getLocale().getLanguage() != null && testResourceBundle.getLocale().getLanguage().length() > 0;
    }

    private ResourceBundle getBundle(String baseName) {
        ResourceBundle testResourceBundle;
        try {
            LOGGER.info("Attempting to get Resource Bundle " + baseName + " for " + this.locale);
            testResourceBundle = ResourceBundle.getBundle(baseName, this.locale);
            if (this.isResourceBundleValid(testResourceBundle)) {
                LOGGER.info("Matched Resource Bundle");
                return testResourceBundle;
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get Resource Bundle " + baseName + " for locale " + this.locale.toString());
        }
        this.locale = Locale.US;
        LOGGER.info("Attempting to get Resource Bundle " + baseName + " for " + this.locale);
        testResourceBundle = ResourceBundle.getBundle(baseName, this.locale);
        if (this.isResourceBundleValid(testResourceBundle)) {
            LOGGER.info("Matched Resource Bundle");
            return testResourceBundle;
        }
        LOGGER.warn("Could not match Resource Bundle");
        return testResourceBundle;
    }
}

