/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;

public class InterruptibleCharSequence
implements CharSequence {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(InterruptibleCharSequence.class);
    CharSequence inner;

    public InterruptibleCharSequence(CharSequence inner) {
        this.inner = inner;
    }

    @Override
    public char charAt(int index) {
        if (Thread.currentThread().isInterrupted()) {
            LOGGER.warn("CharSequence Interrupted");
            throw new RuntimeException("Interrupted!");
        }
        return this.inner.charAt(index);
    }

    @Override
    public int length() {
        return this.inner.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new InterruptibleCharSequence(this.inner.subSequence(start, end));
    }

    @Override
    public String toString() {
        return this.inner.toString();
    }
}

