/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class NameResolver {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NameResolver.class);
    private long nameResolutionTimeout;

    public NameResolver(long nameResolutionTimeout) {
        this.nameResolutionTimeout = nameResolutionTimeout;
    }

    public Collection<String> getLocalIpAddresses() {
        TreeSet<String> ipAddresses = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null) continue;
                    ipAddresses.add(ip.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return ipAddresses;
    }

    public Set<String> getHostIps(String hostname) throws UnknownHostException {
        HashSet<String> results = new HashSet<String>();
        for (InetAddress addr : InetAddress.getAllByName(hostname)) {
            String result = addr.getHostAddress();
            if (addr instanceof Inet6Address && !result.startsWith("[")) {
                result = "[" + result + "]";
            }
            results.add(result);
        }
        return results;
    }

    public String getRemoteName(HttpServletRequest request) {
        String canonicalName;
        String name = request.getRemoteAddr();
        InetAddress address = this.getByName(request.getRemoteAddr());
        if (address != null && !(canonicalName = address.getCanonicalHostName()).equals(name)) {
            name = canonicalName + " (" + name + ")";
        }
        return name;
    }

    public boolean namesNetworkEquivalent(InetSocketAddress address1, InetSocketAddress address2) {
        Set<String> names1 = this.resolveName(address1);
        Set<String> names2 = this.resolveName(address2);
        return this.namesNetworkEquivalent(names1, names2);
    }

    public boolean namesNetworkEquivalent(Set<String> names1, Set<String> names2) {
        if (names1.contains("*") || names2.contains("*")) {
            return true;
        }
        TreeSet<String> copy1 = new TreeSet<String>();
        copy1.addAll(names1);
        copy1.retainAll(names2);
        return copy1.size() > 0;
    }

    public Set<String> resolveName(final InetSocketAddress address) {
        final TreeSet<String> names1 = new TreeSet<String>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                InetSocketAddress resolvedAddress = address;
                String[] locationSplits = resolvedAddress.toString().split(":");
                String hostname = locationSplits[0];
                String[] hosts = hostname.split("/");
                Collections.addAll(names1, hosts);
                if (resolvedAddress.getAddress() == null) {
                    if (hostname.contains("/")) {
                        hostname = hostname.substring(hostname.indexOf("/"));
                    }
                    if (!hostname.equals("<unresolved>")) {
                        resolvedAddress = new InetSocketAddress(hostname, Integer.parseInt(locationSplits[1]));
                    }
                }
                if (resolvedAddress.getAddress() != null) {
                    if (resolvedAddress.getAddress().getHostAddress() != null) {
                        names1.add(resolvedAddress.getAddress().getHostAddress().toLowerCase() + ":" + resolvedAddress.getPort());
                    }
                    if (resolvedAddress.getAddress().getCanonicalHostName() != null) {
                        names1.add(resolvedAddress.getAddress().getCanonicalHostName().toLowerCase() + ":" + resolvedAddress.getPort());
                    }
                    if (resolvedAddress.getAddress().getHostName() != null) {
                        names1.add(resolvedAddress.getAddress().getHostName().toLowerCase() + ":" + resolvedAddress.getPort());
                    }
                }
                if (resolvedAddress.getHostName() != null) {
                    names1.add(resolvedAddress.getHostName());
                }
                if (resolvedAddress.getHostString() != null) {
                    names1.add(resolvedAddress.getHostString());
                }
                if (names1.isEmpty()) {
                    LOGGER.warn("Could not resolve address " + resolvedAddress);
                }
            }
        });
        thread.setName("Name Resolver");
        thread.start();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Waiting " + this.nameResolutionTimeout * 2L + " ms for resolution");
            }
            thread.join(this.nameResolutionTimeout);
            if (thread.isAlive()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolution did not complete during timeout");
                }
                thread.interrupt();
            }
        }
        catch (InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolution did not complete during timeout");
            }
            thread.interrupt();
        }
        LOGGER.info("Resolve Name Done");
        return names1;
    }

    public InetAddress getByName(final String ip) {
        final ArrayList addresses = new ArrayList();
        Object result = null;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    addresses.add(InetAddress.getByName(ip));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        });
        thread.setName("Name Resolver");
        thread.start();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Waiting " + this.nameResolutionTimeout + " ms for " + ip + " resolution");
            }
            thread.join(this.nameResolutionTimeout);
            if (thread.isAlive()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolution did not complete during timeout");
                }
                thread.interrupt();
            }
        }
        catch (InterruptedException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolution did not complete during timeout");
            }
            thread.interrupt();
        }
        if (addresses.size() > 0) {
            return (InetAddress)addresses.get(0);
        }
        return null;
    }
}

