/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;

public final class NetworkUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NetworkUtils.class);
    private static Random r = new Random();

    public static int getAvailablePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    public static int getRandomPort() {
        return r.nextInt(65535);
    }

    public static void startDebugShutdownSocket() {
        String shutdownPort = System.getProperty("debug.shutdownPort");
        if (shutdownPort != null) {
            Thread shutdownHookThread = new Thread(() -> {
                try (ServerSocket serverSocket = new ServerSocket(Integer.parseInt(shutdownPort));){
                    LOGGER.info("Listening to shutdown hook on port " + shutdownPort);
                    Socket socket = serverSocket.accept();
                    LOGGER.info("Got connection on shutdown hook");
                    System.exit(0);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot listen to shutdown hook", e);
                }
            });
            shutdownHookThread.start();
        }
    }
}

