/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.MimeTypeStat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OperationMimeTypeStats
implements Serializable {
    private int operationIndex;
    private String jobId;
    private Map<String, MimeTypeStat> operationMimeTypeStats;
    private List<String> observedColumnNames;
    private long volumeStartEpoch;
    private long volumeLastEpoch;
    private long volumeBytes;

    public OperationMimeTypeStats() {
        this.operationMimeTypeStats = new ConcurrentHashMap<String, MimeTypeStat>();
        this.observedColumnNames = new ArrayList<String>();
    }

    public OperationMimeTypeStats(OperationMimeTypeStats copy) {
        this.operationIndex = copy.operationIndex;
        this.jobId = copy.getJobId();
        this.operationMimeTypeStats = copy.getOperationMimeTypeStats();
        this.observedColumnNames = copy.observedColumnNames;
    }

    public void setOperationIndex(int index) {
        this.operationIndex = index;
    }

    public int getOperationIndex() {
        return this.operationIndex;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Map<String, MimeTypeStat> getOperationMimeTypeStats() {
        return this.operationMimeTypeStats;
    }

    public void setOperationMimeTypeStats(Map<String, MimeTypeStat> operationMimeTypeStats) {
        this.operationMimeTypeStats = operationMimeTypeStats;
    }

    public void trackItemProcessedIrregular(String mimeType, boolean corrupted, boolean encrypted, boolean deleted) {
        this.trackItemProcessedInStage(mimeType, "processed");
        if (corrupted) {
            this.trackItemProcessedInStage(mimeType, "corrupted");
        }
        if (encrypted) {
            this.trackItemProcessedInStage(mimeType, "encrypted");
        }
        if (deleted) {
            this.trackItemProcessedInStage(mimeType, "deleted");
        }
    }

    public void trackItemProcessedRegular(String mimeType, String stageName) {
        this.trackItemProcessedInStage(mimeType, stageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackItemProcessedStage(String stageName) {
        List<String> list = this.observedColumnNames;
        synchronized (list) {
            this.observedColumnNames.add(stageName);
        }
    }

    public void trackItemProcessedFailed(String mimeType, String stageName, boolean failed) {
        this.trackItemProcessedInStage(mimeType, stageName + "_processed");
        if (failed) {
            this.trackItemProcessedInStage(mimeType, stageName + "_failed");
        }
    }

    public void trackItemProcessed(String mimeType, boolean failed) {
        if (failed) {
            this.trackItemProcessedInStage(mimeType, "failed");
        }
        this.trackItemProcessedInStage(mimeType, "processed");
    }

    private void trackItemProcessedInStage(String mimeType, String effectiveStageName) {
        MimeTypeStat mimeTypeStat = this.operationMimeTypeStats.computeIfAbsent(mimeType, s -> new MimeTypeStat(mimeType));
        mimeTypeStat.incrementStageCount(effectiveStageName);
    }

    public List<String> getObservedColumnNames() {
        return this.observedColumnNames;
    }

    public void setObservedColumnNames(List<String> observedColumnNames) {
        this.observedColumnNames = observedColumnNames;
    }

    public List<String> getSortedStageNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("preparing_item_processed");
        result.add("preparing_item_failed");
        result.add("export_binary_processed");
        result.add("export_binary_failed");
        result.add("generate_image_processed");
        result.add("generate_image_failed");
        result.add("extract_text_processed");
        result.add("extract_text_failed");
        result.add("update_text_processed");
        result.add("update_text_failed");
        result.add("update_pdf_processed");
        result.add("update_pdf_failed");
        result.addAll(this.observedColumnNames);
        return result;
    }

    public long getVolumeBytes() {
        return this.volumeBytes;
    }

    public void setVolumeBytes(long volumeBytes) {
        this.volumeBytes = volumeBytes;
    }

    public synchronized void incrementBytes(long volumeBytes) {
        this.volumeBytes += volumeBytes;
    }

    public long getVolumeStartEpoch() {
        return this.volumeStartEpoch;
    }

    public void setVolumeStartEpoch(long volumeStartEpoch) {
        this.volumeStartEpoch = volumeStartEpoch;
    }

    public long getVolumeLastEpoch() {
        return this.volumeLastEpoch;
    }

    public void setVolumeLastEpoch(long volumeLastEpoch) {
        this.volumeLastEpoch = volumeLastEpoch;
    }
}

