/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.SerializationUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;

public class ResourceUtils {
    public static final String TAG_TASK_JOB_SUBMISSION = "Job Submission";

    public static String getRemoteRequestUrl(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        String xForwardedBaseUri = req.getHeader("X-Forwarded-Base-Uri");
        if (xForwardedBaseUri != null && !xForwardedBaseUri.isEmpty()) {
            return xForwardedBaseUri;
        }
        return req.getRequestURL().toString();
    }

    public static String getRemoteIpAddresses(HttpServletRequest req) {
        String xRealIp;
        if (req == null) {
            return "N/A";
        }
        String ipAddress = req.getRemoteAddr();
        String xForwardedFor = req.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && xForwardedFor.length() > 0 && !xForwardedFor.equals(ipAddress)) {
            ipAddress = ipAddress + "," + xForwardedFor;
        }
        if ((xRealIp = req.getHeader("X-Real-IP")) != null && xRealIp.length() > 0 && !xRealIp.equals(ipAddress) && !xRealIp.equals(xForwardedFor)) {
            ipAddress = ipAddress + "," + xRealIp;
        }
        return ipAddress;
    }

    public static String getSchedulerUrl(HttpServletRequest req, UriInfo uriInfo, boolean ignoreProxy) {
        String proxyUri;
        if (!ignoreProxy && (proxyUri = req.getHeader("X-Forwarded-Base-Uri")) != null && proxyUri.length() > 0) {
            if (proxyUri.endsWith("/")) {
                return proxyUri;
            }
            return proxyUri + "/";
        }
        String baseUri = uriInfo.getBaseUri().toString().replace("/api", "");
        return baseUri;
    }

    public static String getBaseUri(HttpServletRequest req, UriInfo uriInfo) {
        String proxyUri = req.getHeader("X-Forwarded-Base-Uri");
        if (proxyUri != null && proxyUri.length() > 0) {
            if (proxyUri.endsWith("/")) {
                return proxyUri + "api/";
            }
            return proxyUri + "/api/";
        }
        return uriInfo.getBaseUri().toString();
    }

    public static String getProxiedAbsoluteUri(String uri, HttpServletRequest req) {
        String proxyUri = req.getHeader("X-Forwarded-Base-Uri");
        if (proxyUri != null && proxyUri.length() > 0) {
            if (uri.startsWith("/")) {
                uri = uri.substring(1);
            }
            if (proxyUri.endsWith("/")) {
                return proxyUri + uri;
            }
            return proxyUri + "/" + uri;
        }
        return uri;
    }

    public static String getBaseUriPath(HttpServletRequest req, @Context UriInfo uriInfo) {
        String proxyUri = req.getHeader("X-Forwarded-Base-Uri");
        if (proxyUri != null && proxyUri.length() > 0) {
            return URI.create(req.getHeader("X-Forwarded-Base-Uri")).getPath() + "api/";
        }
        return uriInfo.getBaseUri().toString();
    }

    public static void throwResponseError(Response response) throws IOException {
        ResourceUtils.throwResponseError(response, null);
    }

    public static void throwResponseError(Response response, String errorMessagePrefix) throws IOException {
        String errorMessage = ResourceUtils.getResponseErrorMessage(response, errorMessagePrefix);
        if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
            throw new ForbiddenException(errorMessage);
        }
        throw new IOException(errorMessage);
    }

    public static String getResponseErrorMessage(Response response) throws IOException {
        return ResourceUtils.getResponseErrorMessage(response, null);
    }

    public static String getResponseErrorMessage(Response response, String errorMessagePrefix) throws IOException {
        String error;
        if (response instanceof OutboundJaxrsResponse) {
            error = ResourceUtils.getEntityAsString((OutboundJaxrsResponse)response);
        } else {
            response.bufferEntity();
            error = (String)response.readEntity(String.class);
        }
        String errorMessage = "";
        if (errorMessagePrefix != null) {
            errorMessage = errorMessage + errorMessagePrefix + ", ";
        }
        errorMessage = errorMessage + "HTTP/" + response.getStatus() + " " + error;
        return errorMessage;
    }

    private static String getEntityAsString(OutboundJaxrsResponse response) throws IOException {
        Object entity = response.getEntity();
        if (entity instanceof TranslationResponseStatus) {
            TranslationResponseStatus responseStatus = (TranslationResponseStatus)entity;
            return SerializationUtils.toDbJson(responseStatus);
        }
        StreamingOutput output = (StreamingOutput)response.getEntity();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            output.write((OutputStream)baos);
            String string = baos.toString("UTF-8");
            return string;
        }
    }
}

