/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

public class ResponseUtils {
    private static final int DEFAULT_MAX_CONCISE_LIST_SIZE = 50;

    private ResponseUtils() {
    }

    public static Response buildStreamingOutputResponse(StreamingOutput streamingOutput, String fileName) {
        return Response.status((Response.Status)Response.Status.OK).type("application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).entity((Object)streamingOutput).build();
    }

    public static List<ConciseObject> getConciseList(List objectList) {
        return ResponseUtils.getConciseList(objectList, Integer.MAX_VALUE);
    }

    public static List<ConciseObject> getConciseList(List objectList, Integer maxCount) {
        ArrayList<ConciseObject> results = new ArrayList<ConciseObject>();
        if (maxCount == null) {
            maxCount = 50;
        }
        for (Object sourceObject : objectList) {
            ConciseObject conciseObject = new ConciseObject();
            for (Method conciseObjectMethod : ConciseObject.class.getMethods()) {
                if (!conciseObjectMethod.getName().startsWith("set")) continue;
                String getterName = "get" + conciseObjectMethod.getName().substring(3);
                try {
                    Method sourceObjectGetterMethod = sourceObject.getClass().getMethod(getterName, new Class[0]);
                    Object sourceValue = sourceObjectGetterMethod.invoke(sourceObject, new Object[0]);
                    try {
                        conciseObjectMethod.invoke((Object)conciseObject, sourceValue);
                    }
                    catch (IllegalArgumentException e) {
                        conciseObjectMethod.invoke((Object)conciseObject, String.valueOf(sourceValue));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (conciseObject.getName() == null && conciseObject.getId() == null) continue;
            if (sourceObject instanceof ThirdPartyService) {
                conciseObject.setType(sourceObject.getClass().getSimpleName());
            }
            results.add(conciseObject);
            if (results.size() < maxCount) continue;
            break;
        }
        return results;
    }
}

