/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.cache.CachedObject;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;

public abstract class StatusLogger {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(StatusLogger.class);
    private final CachedObjectMap<String> seenCache;
    private final String id;
    private final Status status;
    private final CircularBufferLog log;

    public StatusLogger(String id, Status status, CircularBufferLog log) {
        this(id, status, log, 1800L);
    }

    public StatusLogger(String id, Status status, CircularBufferLog log, long expireSeconds) {
        this.id = id;
        this.status = status;
        this.log = log;
        this.seenCache = new CachedObjectMap(expireSeconds * 1000L, 128);
    }

    public void addLog(String line) {
        LOGGER.info(line);
        this.log.addLog(line);
        this.onLogUpdated();
    }

    public void addInfo(String info) {
        if (this.putCache(info)) {
            LOGGER.info(this.id + ": " + info);
            this.log.addLog(info);
        }
        if (this.status.getCode() == State.ERROR || this.status.getCode() == State.WARNING) {
            if (!this.status.getMessage().contains(info)) {
                this.status.setInfoMessage(info);
            }
        } else {
            this.status.setInfoMessage(info);
        }
        this.onLogUpdated();
    }

    public void addWarning(String warning) {
        this.addWarning(warning, true);
    }

    public void addWarning(String warning, boolean addLog) {
        if (addLog && this.putCache(warning)) {
            LOGGER.warn(this.id + ": " + warning);
            this.log.addLog(warning);
        }
        if (this.status.getCode() == State.ERROR) {
            if (!this.status.getMessage().contains(warning)) {
                this.status.setWarningMessage(warning);
            }
        } else {
            this.status.setWarningMessage(warning);
        }
        this.onLogUpdated();
    }

    public void addError(String error) {
        this.addError(error, true);
    }

    public void addError(String error, boolean updateStatus) {
        LOGGER.error(this.id + ": " + error);
        this.log.addLog(error);
        if (updateStatus) {
            this.status.setError(error);
        }
        this.onLogUpdated();
    }

    public void reset() {
        this.seenCache.clear();
        this.status.reset();
        this.onLogUpdated();
    }

    private boolean putCache(String line) {
        CachedObject<String> cache = this.seenCache.put(line);
        return cache == null || cache.isExpired();
    }

    public Status getStatus() {
        return this.status;
    }

    public abstract void onLogUpdated();
}

