/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ThreadPoolUtils {
    public static int RUNTIME_AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();

    public static ScheduledThreadPoolExecutor createScheduledThreadPoolExecutor(String name, int corePoolSize) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(corePoolSize);
        scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
        ThreadPoolUtils.setDefaultThreadFactory(scheduledThreadPoolExecutor, name);
        return scheduledThreadPoolExecutor;
    }

    public static ThreadPoolExecutor createTimeoutThreadPool(String name, int corePoolSize) {
        return ThreadPoolUtils.createTimeoutThreadPool(name, corePoolSize, 60);
    }

    public static ThreadPoolExecutor createTimeoutThreadPool(String name, int corePoolSize, int keepAliveSeconds) {
        ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtils.createThreadPool(name, corePoolSize, corePoolSize, keepAliveSeconds);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor createThreadPool(String name, int corePoolSize) {
        return ThreadPoolUtils.createThreadPool(name, corePoolSize, corePoolSize, 0);
    }

    public static ThreadPoolExecutor createThreadPool(String name, int corePoolSize, int maxPoolSize) {
        return ThreadPoolUtils.createThreadPool(name, corePoolSize, maxPoolSize, 60);
    }

    public static ThreadPoolExecutor createThreadPool(String name, int corePoolSize, int maxPoolSize, int keepAliveSeconds) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadPoolUtils.setDefaultThreadFactory(threadPoolExecutor, name);
        return threadPoolExecutor;
    }

    public static void setDefaultThreadFactory(ThreadPoolExecutor threadPoolExecutor, String name) {
        threadPoolExecutor.setThreadFactory(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            t.setName(name + " " + t.getName());
            return t;
        });
    }
}

