/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;

public final class TimeUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TimeUtils.class);
    private static final Pattern periodPattern = Pattern.compile("([0-9\\.]+)([dhms]+)");

    public static Long parsePeriodMs(String period) {
        if (period == null) {
            return null;
        }
        period = period.toLowerCase(Locale.ENGLISH);
        Matcher matcher = periodPattern.matcher(period);
        Instant instant = Instant.EPOCH;
        block14: while (matcher.find()) {
            String typ;
            double num = Double.parseDouble(matcher.group(1));
            switch (typ = matcher.group(2)) {
                case "d": {
                    instant = instant.plus(Duration.ofDays((long)num));
                    continue block14;
                }
                case "h": {
                    instant = instant.plus(Duration.ofHours((long)num));
                    continue block14;
                }
                case "m": {
                    instant = instant.plus(Duration.ofMinutes((long)num));
                    continue block14;
                }
                case "s": {
                    instant = instant.plus(Duration.ofMillis((long)(num * 1000.0)));
                    continue block14;
                }
                case "ms": {
                    instant = instant.plus(Duration.ofMillis((long)num));
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unexpected separator " + typ);
        }
        return instant.toEpochMilli();
    }

    public static long getDaySinceEpoch(DateTime dateTime) {
        return dateTime.getDayOfYear() + (dateTime.getYear() - 1970) * 365;
    }

    public static long getEpochWithNanos(long value) {
        if (value < 9999999999L) {
            return value * 1000L;
        }
        return value;
    }

    public static double getOnShiftPercentage(long startEpoch, long endEpoch, DateTimeZone dateTimeZone) {
        if (endEpoch == startEpoch) {
            return 0.0;
        }
        DateTime startDate = new DateTime(startEpoch).withZone(dateTimeZone);
        DateTime endDate = new DateTime(endEpoch).withZone(dateTimeZone);
        long startDay = TimeUtils.getDaySinceEpoch(startDate);
        long endDay = TimeUtils.getDaySinceEpoch(endDate);
        int millisInADay = 86400000;
        double periodDays = (double)endDay + (double)endDate.getSecondOfDay() / (double)millisInADay - ((double)startDay + (double)startDate.getSecondOfDay() / (double)millisInADay);
        long millisOnShift = 0L;
        long millisOffShift = 0L;
        for (long day = startDay; day <= endDay; ++day) {
            boolean isWeekend;
            DateTime dateTime = startDate.withFieldAdded(DurationFieldType.days(), (int)(day - startDay));
            DateTime dateTimeDay = new DateTime(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), 0, 0, dateTimeZone);
            long dailyStartTimeEpoch = day == startDay ? startEpoch : dateTimeDay.getMillis();
            long dailyEndTimeEpoch = day == endDay ? endEpoch : dateTimeDay.getMillis() + 86400000L - 1L;
            long dailyStartMillisOfDay = dailyStartTimeEpoch - dateTimeDay.getMillis();
            long dailyEndMillisOfDay = dailyEndTimeEpoch - dateTimeDay.getMillis();
            long startShiftMillisOfDay = 28800000L;
            long endShiftMillisOfDay = 64800000L;
            boolean bl = isWeekend = dateTimeDay.getDayOfWeek() == 6 || dateTimeDay.getDayOfWeek() == 7;
            if (isWeekend) {
                millisOffShift += dailyEndMillisOfDay - dailyStartMillisOfDay;
                continue;
            }
            if (dailyStartMillisOfDay < startShiftMillisOfDay) {
                if (dailyEndMillisOfDay < startShiftMillisOfDay) {
                    millisOffShift += dailyEndMillisOfDay - dailyStartMillisOfDay;
                    continue;
                }
                if (dailyEndMillisOfDay < endShiftMillisOfDay) {
                    millisOffShift += startShiftMillisOfDay - dailyStartMillisOfDay;
                    millisOnShift += dailyEndMillisOfDay - startShiftMillisOfDay;
                    continue;
                }
                millisOnShift += endShiftMillisOfDay - startShiftMillisOfDay;
                millisOffShift += dailyEndMillisOfDay - endShiftMillisOfDay + (startShiftMillisOfDay - dailyStartMillisOfDay);
                continue;
            }
            if (dailyStartMillisOfDay < endShiftMillisOfDay) {
                if (dailyEndMillisOfDay < endShiftMillisOfDay) {
                    millisOnShift += dailyEndMillisOfDay - dailyStartMillisOfDay;
                    continue;
                }
                millisOnShift += endShiftMillisOfDay - dailyStartMillisOfDay;
                millisOffShift += dailyEndMillisOfDay - endShiftMillisOfDay;
                continue;
            }
            millisOffShift += dailyEndMillisOfDay - dailyStartMillisOfDay;
        }
        long shiftsDuration = millisOnShift + millisOffShift;
        long periodDuration = endEpoch - startEpoch;
        return (double)millisOnShift / (double)(millisOnShift + millisOffShift);
    }
}

