/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.HashingUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class UidUtils {
    private static final Random random = new SecureRandom();

    public static String fromString(String text) {
        return UidUtils.fromString(text, "O7r>Tsl]esp^.bvf");
    }

    public static String fromString(String text, String salt1, String salt2) {
        return UidUtils.fromString(text, salt1 + "-" + salt2);
    }

    public static String fromString(String text, String salt) {
        return UidUtils.getUUID(text, salt).toString();
    }

    private static UUID getUUID(String text, String salt) {
        byte[] digestBytes = HashingUtils.digestSha256((salt + text + salt).getBytes(StandardCharsets.UTF_8));
        ByteBuffer byteBuffer = ByteBuffer.wrap(digestBytes, 0, 8);
        long mostSigBits = byteBuffer.getLong();
        byteBuffer = ByteBuffer.wrap(digestBytes, 8, 8);
        long leastSigBits = byteBuffer.getLong();
        UUID uuid = new UUID(mostSigBits, leastSigBits);
        return uuid;
    }

    public static String getRandom() {
        String randomString = RandomStringUtils.random((int)32, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)random);
        String value = UidUtils.fromString(randomString);
        return value;
    }

    public static String getShortId(String id, int maxLength) {
        String[] splits = id.split("-");
        id = splits[0];
        return id.substring(0, Math.min(maxLength, id.length()));
    }

    public static String getShortId(String id) {
        return UidUtils.getShortId(id, 5);
    }
}

