/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.CertificateFingerprintException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class WhitelistedX509TrustManager
implements X509TrustManager {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WhitelistedX509TrustManager.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    private final List<X509TrustManager> trustManagers;
    private Set<String> whitelistedCertFingerprints;

    public WhitelistedX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        this.trustManagers = new ArrayList<X509TrustManager>();
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trust manager: " + trustManager);
            }
            if (!(trustManager instanceof X509TrustManager)) continue;
            this.trustManagers.add((X509TrustManager)trustManager);
        }
    }

    public WhitelistedX509TrustManager(Set<String> whitelistedCertFingerprints) throws KeyStoreException, NoSuchAlgorithmException {
        this();
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManagers.isEmpty()) {
            throw new IllegalArgumentException("No trust managers");
        }
        CertificateException exception = null;
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkClientTrusted(chain, authType);
                return;
            }
            catch (CertificateException e) {
                LOGGER.warn("Client not trusted by JVM");
                exception = e;
            }
        }
        throw exception;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager trustManager : this.trustManagers) {
            try {
                trustManager.checkServerTrusted(chain, authType);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        String fingerprint = null;
        if (chain.length > 0) {
            X509Certificate cert = chain[chain.length - 1];
            try {
                fingerprint = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-256").digest(cert.getEncoded())).toLowerCase();
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.error("Cannot compute certificate fingerprint", e);
            }
        }
        if (this.whitelistedCertFingerprints == null || !this.whitelistedCertFingerprints.contains(fingerprint)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Server SHA-256 fingerprint " + fingerprint + " not whitelisted");
            }
            throw new CertificateFingerprintException(iu.getFormattedString("RestClientFactory.CertificateFingerprintNotTrusted", (Object)fingerprint), fingerprint);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }
}

