/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.general.AutomateGeneratedRequestFilter;
import com.nuix.automate.utils.general.ClientManager;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.WhitelistedX509TrustManager;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.AutomateModule;
import io.dropwizard.client.proxy.NonProxyListProxyRoutePlanner;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.HttpClientBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public final class WsRsRestClientFactory {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(WsRsRestClientFactory.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static final Map<String, ClientManager> clientManagers = new HashMap<String, ClientManager>();

    public static HostnameVerifier getAllowAllHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    public static X509TrustManager getTrustManager(Set<String> fingerprints) throws NoSuchAlgorithmException, KeyStoreException {
        return new WhitelistedX509TrustManager(fingerprints);
    }

    public static Client getClient(String name) {
        try {
            return WsRsRestClientFactory.getClientWithWhitelistValidation(name, null, false, true);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Client getClientWithWhitelistValidation(String name, Set<String> whitelistedCertFingerprints, boolean multipartFeature) throws GeneralSecurityException {
        return WsRsRestClientFactory.getClientWithWhitelistValidation(name, whitelistedCertFingerprints, multipartFeature, null, true);
    }

    public static Client getClientWithWhitelistValidation(String name, Set<String> whitelistedCertFingerprints, boolean multipartFeature, boolean reuseExistingClient) throws GeneralSecurityException {
        return WsRsRestClientFactory.getClientWithWhitelistValidation(name, whitelistedCertFingerprints, multipartFeature, null, reuseExistingClient);
    }

    public static String flattenFingerprints(Set<String> whitelistedCertFingerprints) {
        String result = "";
        if (whitelistedCertFingerprints != null && whitelistedCertFingerprints.size() > 0) {
            ArrayList<String> sortedFingerprints = new ArrayList<String>(whitelistedCertFingerprints);
            Collections.sort(sortedFingerprints);
            result = "-" + String.join((CharSequence)",", sortedFingerprints);
        }
        return result;
    }

    public static synchronized Client getClientWithWhitelistValidation(final String name, final Set<String> whitelistedCertFingerprints, final boolean multipartFeature, final ClientConfig clientConfig, boolean reuseExistingClient) throws GeneralSecurityException {
        ClientManager existingClientManager;
        String nameFingerprint = name + WsRsRestClientFactory.flattenFingerprints(whitelistedCertFingerprints);
        if (reuseExistingClient && (existingClientManager = clientManagers.get(nameFingerprint)) != null) {
            try {
                existingClientManager.target("http://localhost");
                LOGGER.info("Reusing client " + name);
                return existingClientManager;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WsRsRestClientFactory.remove(nameFingerprint);
        ClientManager clientManager = new ClientManager(){

            @Override
            protected Client createClient() throws GeneralSecurityException {
                return WsRsRestClientFactory.getClientWithWhitelistValidationInternal(name, whitelistedCertFingerprints, multipartFeature, clientConfig);
            }
        };
        clientManagers.put(nameFingerprint, clientManager);
        return clientManager;
    }

    public static Client getClientWithWhitelistValidationInternal(String name, Set<String> whitelistedCertFingerprints, boolean multipartFeature, ClientConfig clientConfig) throws GeneralSecurityException {
        HashSet<String> fingerprints = new HashSet<String>();
        NetworkConfiguration networkConfiguration = NetworkConfiguration.fromSystemProperties();
        if (networkConfiguration.getWhitelistedCertFingerprints() != null) {
            for (String fingerprint : networkConfiguration.getWhitelistedCertFingerprints()) {
                if (fingerprint == null || fingerprint.trim().isEmpty()) continue;
                fingerprints.add(fingerprint.trim().toLowerCase());
            }
        }
        if (whitelistedCertFingerprints != null) {
            for (String fingerprint : whitelistedCertFingerprints) {
                if (fingerprint == null || fingerprint.trim().isEmpty()) continue;
                fingerprints.add(fingerprint.trim().toLowerCase());
            }
        }
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (clientConfig != null) {
            builder = builder.withConfig((Configuration)clientConfig);
        }
        if (multipartFeature) {
            builder = (ClientBuilder)builder.register(MultiPartFeature.class);
        }
        if (fingerprints.isEmpty()) {
            LOGGER.info("Initializing API Client " + name + " without fingerprints");
        } else {
            LOGGER.info("Initializing API Client " + name + " with fingerprints=" + String.join((CharSequence)";", fingerprints));
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{WsRsRestClientFactory.getTrustManager(fingerprints)}, new SecureRandom());
            builder.sslContext(sslcontext).hostnameVerifier((s1, s2) -> true);
        }
        if (networkConfiguration.isProxyConfigured()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            HttpHost httpHost = new HttpHost(networkConfiguration.getProxyHost(), networkConfiguration.getProxyPort().intValue());
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new NonProxyListProxyRoutePlanner(httpHost, new ArrayList<String>(networkConfiguration.getNonProxyHosts())));
            builder.register((Object)httpClientBuilder);
        }
        Client client = builder.build();
        client.property("jersey.config.client.followRedirects", (Object)false);
        if (name.contains("call-api")) {
            client.register((Object)new AutomateGeneratedRequestFilter(AutomateModule.AUTOMATE_ENGINE_SERVICE));
            client.register(AutomateGeneratedRequestFilter.class);
        }
        return client;
    }

    public static void remove(String name) {
        block3: {
            Client previousClient = clientManagers.remove(name);
            if (previousClient != null) {
                try {
                    previousClient.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Cannot close client", e);
                }
            }
        }
    }

    public static void restartClients() {
        for (ClientManager clientManager : new ArrayList<ClientManager>(clientManagers.values())) {
            try {
                clientManager.restart();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

