/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.general;

import com.nuix.automate.utils.general.CountingZipInputStream;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;

public class ZipUtils {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ZipUtils.class);

    public static List<String> unzipFileData(byte[] data, String fileExtensionFilter) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (CountingZipInputStream zi = new CountingZipInputStream(new ByteArrayInputStream(data));){
            ZipEntry zipEntry;
            while ((zipEntry = ((ZipInputStream)zi).getNextEntry()) != null) {
                if (!zipEntry.getName().toLowerCase().endsWith(fileExtensionFilter.toLowerCase())) continue;
                String unzippedContents = new BufferedReader(new InputStreamReader((InputStream)zi, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                result.add(unzippedContents);
            }
        }
        return result;
    }

    public static Path unzipFile(Path zipPath) throws IOException {
        String zipDirName = FilenameUtils.getBaseName((String)zipPath.getFileName().toString());
        Path dirPath = zipPath.resolveSibling(zipDirName);
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        ZipUtils.unzipFile(zipPath, dirPath);
        return dirPath;
    }

    public static void unzipFile(Path zipPath, Path destPath) throws IOException {
        ZipUtils.unzipFile(Files.newInputStream(zipPath, new OpenOption[0]), destPath);
    }

    public static void unzipFile(InputStream inputStream, Path destPath) throws IOException {
        try (CountingZipInputStream zis = new CountingZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = ((ZipInputStream)zis).getNextEntry()) != null) {
                Path unzipPath = FileUtils.safeResolveParent(destPath, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Files.createDirectories(unzipPath, new FileAttribute[0]);
                    continue;
                }
                if (!Files.exists(unzipPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(unzipPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(zis, unzipPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

