/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.licence.Module;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Licence
implements Serializable,
Cloneable {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(Licence.class);
    private transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    @XmlElement
    public String id = null;
    @XmlElement
    public Date startDate = null;
    @XmlElement
    public Date endDate = null;
    @XmlElement
    private String software = null;
    @XmlElement
    public Set<String> sysId = null;
    @XmlElement
    public String signature = null;
    @XmlElement
    public String signatureV2 = null;
    @XmlElement
    public String licenseInfo = null;

    public Licence clone() throws CloneNotSupportedException {
        Licence clonedObject = (Licence)super.clone();
        clonedObject.sysId = new TreeSet<String>();
        if (this.sysId != null) {
            clonedObject.sysId.addAll(this.sysId);
        }
        return clonedObject;
    }

    public void setLegacySoftware(String software) {
        this.software = software;
    }

    public void addModule(Module m) {
        if (this.software == null) {
            this.software = "";
        }
        if (this.software.length() > 0) {
            this.software = this.software + ",";
        }
        this.software = this.software + m.getCode();
    }

    public String getSoftware() {
        return this.software;
    }

    @JsonIgnore
    public Set<String> getSoftwareModuleCodes() {
        HashSet<String> licenceProducts = new HashSet<String>();
        if (this.software == null) {
            return licenceProducts;
        }
        licenceProducts.addAll(Arrays.asList(this.software.split(",")));
        return licenceProducts;
    }

    @JsonIgnore
    public String getSysIdRepresentation(boolean sorted) {
        if (sorted) {
            ArrayList<String> sortedSysIds = new ArrayList<String>();
            if (this.sysId != null) {
                sortedSysIds.addAll(this.sysId);
            }
            sortedSysIds.sort(String::compareTo);
            return String.join((CharSequence)",", sortedSysIds);
        }
        return this.sysId != null ? String.join((CharSequence)",", this.sysId) : "";
    }

    public String toString() {
        return this.toFormattedString();
    }

    public String toFormattedString() {
        return this.iu.getFormattedString("Licence.Format.NameAndValidityPeriod", this.id, this.startDate, this.endDate) + "\n" + (this.software != null ? this.iu.getFormattedString("Licence.Format.Modules", (Object)this.software) + "\n" : "") + this.iu.getFormattedString("Licence.Format.Id", (Object)this.getSysIdRepresentation(true));
    }

    public String toValidationString(boolean sorted) {
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        utcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String representation = "ID: " + this.id + ", ";
        representation = representation + "Start Date: " + utcDateFormatter.format(this.startDate) + ", ";
        representation = representation + "Expiry Date: " + utcDateFormatter.format(this.endDate) + " ,";
        representation = representation + "Software: " + this.software + ", ";
        representation = representation + this.getSysIdRepresentation(sorted);
        return representation;
    }
}

