/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence;

import com.google.gson.Gson;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.Serializer;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.Edition;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.NuixLicense;
import com.nuix.automate.utils.licence.services.SerializerUtils;
import com.nuix.automate.utils.license.ServerRestClient;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.nuix.Format;
import com.nuix.automate.utils.nuix.Version;
import com.nuix.automate.utils.security.Encryptor;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.GenericType;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LicenceFactory {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LicenceFactory.class);
    private transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private static LicenceFactory instance = null;
    List<String> licenseDefaultPaths = new ArrayList<String>();
    public static final String LICENSE_FILENAME = "licence.bin";
    public static final String CREDENTIALS_FILENAME = "credentials";
    public static final String LICENSE_INFO_FILENAME = "licenseInfo";
    public static final String EVENTS_FOLDERNAME = "cache";
    private static final int PING_INTERVAL = 60000;
    private Licence licence = null;
    private SerializerUtils serializerUtils;
    private Encryptor encryptor;
    private ModuleType requiredModule;

    public LicenceFactory() {
        if (System.getProperty("os.name").contains("Windows")) {
            this.licenseDefaultPaths.add(System.getenv("PROGRAMDATA") + "\\Nuix\\Automate\\Licence");
        } else {
            this.licenseDefaultPaths.add("/etc/nuix/automate");
            this.licenseDefaultPaths.add(System.getProperty("user.home") + "/.automate");
        }
        this.serializerUtils = new SerializerUtils();
        this.encryptor = Encryptor.getSystemInstance();
        this.requiredModule = ModuleType.SCHEDULER_STANDARD;
    }

    public void setRequiredModule(ModuleType requiredModule) {
        this.requiredModule = requiredModule;
    }

    public Credentials getCredentials() {
        String credentialsFileName = this.getLocation(CREDENTIALS_FILENAME);
        Credentials credentials = null;
        File credentialsFile = new File(credentialsFileName);
        if (credentialsFile.exists() && !credentialsFile.isDirectory()) {
            try {
                credentials = this.serializerUtils.deserialize(Paths.get(credentialsFile.getAbsolutePath(), new String[0]), new GenericType<Credentials>(){});
                try {
                    credentials.setLicenseKey(this.encryptor.decrypt(credentials.getLicenseKey()));
                }
                catch (Exception e) {
                    LOGGER.error("Cannot decrypt credentials", e);
                    credentials.setLicenseKey(null);
                }
                return credentials;
            }
            catch (IOException e) {
                LOGGER.error("Cannot read credentials file " + credentialsFile, e);
                LOGGER.error("Unexpected error", e);
            }
        } else {
            LOGGER.warn("Credentials file " + credentialsFile + " does not exist");
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LicenceFactory getInstance() {
        Class<LicenceFactory> clazz = LicenceFactory.class;
        synchronized (LicenceFactory.class) {
            if (instance == null) {
                instance = new LicenceFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void main(String[] args) {
    }

    private boolean sysIdFormatCorrect(String sysId) {
        Pattern p = Pattern.compile("sysid[^\\n]*");
        Matcher m = p.matcher(sysId);
        return m.matches();
    }

    public boolean isSignatureValid(Licence licence) {
        if (licence == null || licence.startDate == null || licence.endDate == null || licence.id == null || licence.sysId == null || licence.signature == null) {
            return false;
        }
        try {
            byte[] signatureToVerify = licence.signatureV2 != null ? DatatypeConverter.parseHexBinary((String)licence.signatureV2) : DatatypeConverter.parseHexBinary((String)licence.signature);
            String publicKeyString = "308203433082023506072a8648ce3804013082022802820101008f7935d9b9aae9bfabed887acf4951b6f32ec59e3baf3718e8eac4961f3efd3606e74351a9c4183339b809e7c2ae1c539ba7475b85d011adb8b47987754984695cac0e8f14b3360828a22ffa27110a3d62a993453409a0fe696c4658f84bdd20819c3709a01057b195adcd00233dba5484b6291f9d648ef883448677979cec04b434a6ac2e75e9985de23db0292fc1118c9ffa9d8181e7338db792b730d7b9e349592f68099872153915ea3d6b8b4653c633458f803b32a4c2e0f27290256e4e3f8a3b0838a1c450e4e18c1a29a37ddf5ea143de4b66ff04903ed5cf1623e158d487c608e97f211cd81dca23cb6e380765f822e342be484c05763939601cd667021d00baf696a68578f7dfdee7fa67c977c785ef32b233bae580c0bcd5695d0282010016a65c58204850704e7502a39757040d34da3a3478c154d4e4a5c02d242ee04f96e61e4bd0904abdac8f37eeb1e09f3182d23c9043cb642f88004160edf9ca09b32076a79c32a627f2473e91879ba2c4e744bd2081544cb55b802c368d1fa83ed489e94e0fa0688e32428a5c78c478c68d0527b71c9a3abb0b0be12c44689639e7d3ce74db101a65aa2b87f64c6826db3ec72f4b5599834bb4edb02f7c90e9a496d3a55d535bebfc45d4f619f63f3dedbb873925c2f224e07731296da887ec1e4748f87efb5fdeb75484316b2232dee553ddaf02112b0d1f02da30973224fe27aeda8b9d4b2922d9ba8be39ed9e103a63c52810bc688b7e2ed4316e1ef17dbde03820106000282010100804a0040cd1593a31ce9f581946f574d28f3a86b6b887d2db9d19ef8ba8b4b95020eb2dc928933f528d891a39b20b63141095527ece0fb8376fa5a82f0daa9932d1364d96903510e88f4cf252b1cf9cc57553d2a545d83aa30f09123385654c78a5817f3ed1830eb599fb7e8c2be8349ab6d8afb039f1bd1d88687bdc5d803c8fd17f2eab02a6f01963c20ffeeb199d7d54fabfe37ea076267070a32748831048cc04348ed2bd13f43dfae84efc1bfbed435d46f7f9edc47adf92d24c76a4c490fc7d09df0211e6bd86a1a70f65c5920f5c1546f7f049b07b611c6cdb208fda295791a4f7202f251c0aa60031e7eba2fb1bd203ec091f73da423c4effacc815f";
            byte[] publicKeyBytes = DatatypeConverter.parseHexBinary((String)publicKeyString);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] inputData = licence.toValidationString(licence.signatureV2 != null).getBytes("UTF8");
            Signature dsa = Signature.getInstance("SHA256withDSA", "SUN");
            dsa.initVerify(publicKey);
            dsa.update(inputData, 0, inputData.length);
            return dsa.verify(signatureToVerify);
        }
        catch (Exception e) {
            LOGGER.error("Error encountered while attempting to verify licence signature.", e);
            return false;
        }
    }

    public boolean isSignatureValidV2(LicenceInfo licenceInfo) {
        if (licenceInfo == null || licenceInfo.getSignatureV2() == null) {
            return false;
        }
        try {
            byte[] signatureToVerify = DatatypeConverter.parseHexBinary((String)licenceInfo.getSignatureV2());
            String publicKeyString = "308203433082023506072a8648ce3804013082022802820101008f7935d9b9aae9bfabed887acf4951b6f32ec59e3baf3718e8eac4961f3efd3606e74351a9c4183339b809e7c2ae1c539ba7475b85d011adb8b47987754984695cac0e8f14b3360828a22ffa27110a3d62a993453409a0fe696c4658f84bdd20819c3709a01057b195adcd00233dba5484b6291f9d648ef883448677979cec04b434a6ac2e75e9985de23db0292fc1118c9ffa9d8181e7338db792b730d7b9e349592f68099872153915ea3d6b8b4653c633458f803b32a4c2e0f27290256e4e3f8a3b0838a1c450e4e18c1a29a37ddf5ea143de4b66ff04903ed5cf1623e158d487c608e97f211cd81dca23cb6e380765f822e342be484c05763939601cd667021d00baf696a68578f7dfdee7fa67c977c785ef32b233bae580c0bcd5695d0282010016a65c58204850704e7502a39757040d34da3a3478c154d4e4a5c02d242ee04f96e61e4bd0904abdac8f37eeb1e09f3182d23c9043cb642f88004160edf9ca09b32076a79c32a627f2473e91879ba2c4e744bd2081544cb55b802c368d1fa83ed489e94e0fa0688e32428a5c78c478c68d0527b71c9a3abb0b0be12c44689639e7d3ce74db101a65aa2b87f64c6826db3ec72f4b5599834bb4edb02f7c90e9a496d3a55d535bebfc45d4f619f63f3dedbb873925c2f224e07731296da887ec1e4748f87efb5fdeb75484316b2232dee553ddaf02112b0d1f02da30973224fe27aeda8b9d4b2922d9ba8be39ed9e103a63c52810bc688b7e2ed4316e1ef17dbde03820106000282010100804a0040cd1593a31ce9f581946f574d28f3a86b6b887d2db9d19ef8ba8b4b95020eb2dc928933f528d891a39b20b63141095527ece0fb8376fa5a82f0daa9932d1364d96903510e88f4cf252b1cf9cc57553d2a545d83aa30f09123385654c78a5817f3ed1830eb599fb7e8c2be8349ab6d8afb039f1bd1d88687bdc5d803c8fd17f2eab02a6f01963c20ffeeb199d7d54fabfe37ea076267070a32748831048cc04348ed2bd13f43dfae84efc1bfbed435d46f7f9edc47adf92d24c76a4c490fc7d09df0211e6bd86a1a70f65c5920f5c1546f7f049b07b611c6cdb208fda295791a4f7202f251c0aa60031e7eba2fb1bd203ec091f73da423c4effacc815f";
            byte[] publicKeyBytes = DatatypeConverter.parseHexBinary((String)publicKeyString);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] inputData = licenceInfo.toValidationStringV2().getBytes("UTF8");
            Signature dsa = Signature.getInstance("SHA256withDSA", "SUN");
            dsa.initVerify(publicKey);
            dsa.update(inputData, 0, inputData.length);
            return dsa.verify(signatureToVerify);
        }
        catch (Exception e) {
            LOGGER.error("Error encountered while attempting to verify licence signature.", e);
            return false;
        }
    }

    public boolean isSignatureValid(LicenceInfo licenceInfo) {
        if (licenceInfo == null || licenceInfo.getSignature() == null) {
            return false;
        }
        try {
            byte[] signatureToVerify = DatatypeConverter.parseHexBinary((String)licenceInfo.getSignature());
            String publicKeyString = "308203433082023506072a8648ce3804013082022802820101008f7935d9b9aae9bfabed887acf4951b6f32ec59e3baf3718e8eac4961f3efd3606e74351a9c4183339b809e7c2ae1c539ba7475b85d011adb8b47987754984695cac0e8f14b3360828a22ffa27110a3d62a993453409a0fe696c4658f84bdd20819c3709a01057b195adcd00233dba5484b6291f9d648ef883448677979cec04b434a6ac2e75e9985de23db0292fc1118c9ffa9d8181e7338db792b730d7b9e349592f68099872153915ea3d6b8b4653c633458f803b32a4c2e0f27290256e4e3f8a3b0838a1c450e4e18c1a29a37ddf5ea143de4b66ff04903ed5cf1623e158d487c608e97f211cd81dca23cb6e380765f822e342be484c05763939601cd667021d00baf696a68578f7dfdee7fa67c977c785ef32b233bae580c0bcd5695d0282010016a65c58204850704e7502a39757040d34da3a3478c154d4e4a5c02d242ee04f96e61e4bd0904abdac8f37eeb1e09f3182d23c9043cb642f88004160edf9ca09b32076a79c32a627f2473e91879ba2c4e744bd2081544cb55b802c368d1fa83ed489e94e0fa0688e32428a5c78c478c68d0527b71c9a3abb0b0be12c44689639e7d3ce74db101a65aa2b87f64c6826db3ec72f4b5599834bb4edb02f7c90e9a496d3a55d535bebfc45d4f619f63f3dedbb873925c2f224e07731296da887ec1e4748f87efb5fdeb75484316b2232dee553ddaf02112b0d1f02da30973224fe27aeda8b9d4b2922d9ba8be39ed9e103a63c52810bc688b7e2ed4316e1ef17dbde03820106000282010100804a0040cd1593a31ce9f581946f574d28f3a86b6b887d2db9d19ef8ba8b4b95020eb2dc928933f528d891a39b20b63141095527ece0fb8376fa5a82f0daa9932d1364d96903510e88f4cf252b1cf9cc57553d2a545d83aa30f09123385654c78a5817f3ed1830eb599fb7e8c2be8349ab6d8afb039f1bd1d88687bdc5d803c8fd17f2eab02a6f01963c20ffeeb199d7d54fabfe37ea076267070a32748831048cc04348ed2bd13f43dfae84efc1bfbed435d46f7f9edc47adf92d24c76a4c490fc7d09df0211e6bd86a1a70f65c5920f5c1546f7f049b07b611c6cdb208fda295791a4f7202f251c0aa60031e7eba2fb1bd203ec091f73da423c4effacc815f";
            byte[] publicKeyBytes = DatatypeConverter.parseHexBinary((String)publicKeyString);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] inputData = licenceInfo.toValidationString().getBytes("UTF8");
            Signature dsa = Signature.getInstance("SHA256withDSA", "SUN");
            dsa.initVerify(publicKey);
            dsa.update(inputData, 0, inputData.length);
            return dsa.verify(signatureToVerify);
        }
        catch (Exception e) {
            LOGGER.error("Error encountered while attempting to verify licence signature.", e);
            return false;
        }
    }

    public boolean isLicenceExpired(LicenceInfo licence) {
        return new Date(licence.getEndDate()).compareTo(DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate()) < 0;
    }

    public boolean isLicenceStale(LicenceInfo licence) {
        if (licence.getCacheValidityDate() == null) {
            return true;
        }
        return new Date(licence.getCacheValidityDate()).compareTo(DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate()) < 0;
    }

    public boolean isLicenceNotValidYet(LicenceInfo licence) {
        return new Date(licence.getStartDate()).compareTo(DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate()) > 0;
    }

    public Set<String> getSoftwareSysIds() {
        HashSet<String> result = new HashSet<String>();
        result.add("n/a");
        return result;
    }

    public String getSoftwareDetails() {
        return this.getSoftwareDetails(Format.TEXT);
    }

    public String getSoftwareDetails(Format format) {
        return "n/a";
    }

    public String validateSysIds(LicenceInfo licenceInfo, Set<String> expectedAnyId) {
        for (NuixLicense nuixLicense : licenceInfo.getNuixLicenses()) {
            if (nuixLicense.getSysId().equalsIgnoreCase("*")) {
                return null;
            }
            for (String expectedId : expectedAnyId) {
                if (!nuixLicense.getSysId().equalsIgnoreCase(expectedId)) continue;
                return null;
            }
        }
        return this.iu.getString("Licence.Error.InvalidIdentifier");
    }

    public String getLicenceErrorMessage(LicenceInfo licenceInfo) {
        String errorMessage = null;
        try {
            if (licenceInfo == null) {
                errorMessage = this.iu.getString("Licence.Error.NoLicenceFound");
            } else if ((licenceInfo.getEditions() != null && licenceInfo.getEditions().size() > 1 || licenceInfo.getSignatureV2() != null) && !this.isSignatureValidV2(licenceInfo)) {
                errorMessage = this.iu.getString("Licence.Error.InvalidSignature");
            } else if (!(licenceInfo.getEditions() != null && licenceInfo.getEditions().size() != 1 || licenceInfo.getSignatureV2() != null || this.isSignatureValid(licenceInfo))) {
                errorMessage = this.iu.getString("Licence.Error.InvalidSignature");
            } else if (!licenceInfo.getEnabled()) {
                errorMessage = this.iu.getString("Licence.Error.NotEnabled");
            } else if (this.requiredModule != null && !licenceInfo.getModuleLicensed(this.requiredModule)) {
                errorMessage = this.iu.getFormattedString("Licence.Error.ModuleNotLicensed", (Object)this.requiredModule.toLocalizedString());
            } else if (this.isLicenceExpired(licenceInfo)) {
                errorMessage = this.iu.getFormattedString("Licence.Error.Expired", new Object[]{new Date(licenceInfo.getEndDate())});
            } else if (this.isLicenceStale(licenceInfo)) {
                errorMessage = this.iu.getString("Licence.Error.Stale");
            } else if (this.isLicenceNotValidYet(licenceInfo)) {
                errorMessage = this.iu.getFormattedString("Licence.Error.NotValidYet", new Object[]{new Date(licenceInfo.getStartDate())});
            } else {
                String printableVersion = LicenceFactory.class.getPackage().getImplementationVersion();
                Version version = new Version(printableVersion);
                if (version.getMajor() > 99) {
                    boolean isLegacyEdition = true;
                    for (Edition edition : licenceInfo.getEditions()) {
                        if (!edition.name().toLowerCase().contains("neo") && !Edition.INTERNAL_TESTING.equals((Object)edition)) continue;
                        isLegacyEdition = false;
                        break;
                    }
                    if (isLegacyEdition) {
                        errorMessage = this.iu.getString("Licence.Error.UnsupportedComponentLicenseEdition");
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid license", e);
            errorMessage = this.iu.getString("Licence.Error.InvalidSignature");
        }
        return errorMessage;
    }

    public Licence readLicenceFromFile(File licenceFile) {
        if (licenceFile.exists() && !licenceFile.isDirectory()) {
            try {
                this.licence = Serializer.deserializeLicence(licenceFile);
                return this.licence;
            }
            catch (JAXBException e) {
                LOGGER.error("Cannot read licence file " + licenceFile, e);
                LOGGER.error("Unexpected error", e);
            }
        } else {
            LOGGER.error("Licence file " + licenceFile + " does not exist");
        }
        return null;
    }

    public synchronized String getLicenceLocation() {
        String candidatePath;
        String licenceFile = null;
        for (String defaultPath : this.licenseDefaultPaths) {
            String candidateLicenceFile = defaultPath + "/" + LICENSE_FILENAME;
            if (!Files.exists(Paths.get(candidateLicenceFile, new String[0]), new LinkOption[0])) continue;
            licenceFile = candidateLicenceFile;
            break;
        }
        if (licenceFile == null) {
            for (String defaultPath : this.licenseDefaultPaths) {
                candidatePath = defaultPath;
                if (!Files.exists(Paths.get(candidatePath, new String[0]), new LinkOption[0])) continue;
                licenceFile = candidatePath + "/" + LICENSE_FILENAME;
                break;
            }
        }
        if (licenceFile == null) {
            Iterator<String> iterator = this.licenseDefaultPaths.iterator();
            while (iterator.hasNext()) {
                String defaultPath;
                candidatePath = defaultPath = iterator.next();
                try {
                    new File(candidatePath).mkdirs();
                    licenceFile = candidatePath + "/" + LICENSE_FILENAME;
                    break;
                }
                catch (Throwable t) {
                    if (Files.exists(Paths.get(candidatePath, new String[0]), new LinkOption[0])) {
                        licenceFile = candidatePath + "/" + LICENSE_FILENAME;
                        break;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot create directory " + candidatePath);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Licence file location: " + licenceFile);
        }
        return licenceFile;
    }

    public synchronized String getLocation(String fileName) {
        String candidatePath;
        String filePath = null;
        if (filePath == null) {
            for (String defaultPath : this.licenseDefaultPaths) {
                String candidateLicenceFile = defaultPath + "/" + fileName;
                if (!Files.exists(Paths.get(candidateLicenceFile, new String[0]), new LinkOption[0])) continue;
                filePath = candidateLicenceFile;
                break;
            }
        }
        if (filePath == null) {
            for (String defaultPath : this.licenseDefaultPaths) {
                candidatePath = defaultPath;
                if (!Files.exists(Paths.get(candidatePath, new String[0]), new LinkOption[0])) continue;
                filePath = candidatePath + "/" + fileName;
                break;
            }
        }
        if (filePath == null) {
            Iterator<String> iterator = this.licenseDefaultPaths.iterator();
            while (iterator.hasNext()) {
                String defaultPath;
                candidatePath = defaultPath = iterator.next();
                try {
                    new File(candidatePath).mkdirs();
                    filePath = candidatePath + "/" + fileName;
                    break;
                }
                catch (Throwable t) {
                    if (Files.exists(Paths.get(candidatePath, new String[0]), new LinkOption[0])) {
                        filePath = candidatePath + "/" + fileName;
                        break;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot create directory " + candidatePath);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File location: " + filePath);
        }
        return filePath;
    }

    public Licence getDeployedLicence() {
        return this.readLicenceFromFile(new File(this.getLicenceLocation()));
    }

    public LicenceInfo getDeployedLicenceInfo() throws IOException {
        return this.serializerUtils.deserialize(Paths.get(this.getLocation(LICENSE_INFO_FILENAME), new String[0]), new GenericType<LicenceInfo>(){});
    }

    private void clearDeployedLicense() {
        File licenceFile = new File(this.getLicenceLocation());
        if (licenceFile.exists()) {
            licenceFile.delete();
        }
    }

    private void clearDeployedCredentials() {
        File licenseInfoFile;
        File credentialsFile = new File(this.getLocation(CREDENTIALS_FILENAME));
        if (credentialsFile.exists()) {
            credentialsFile.delete();
        }
        if ((licenseInfoFile = new File(this.getLocation(LICENSE_INFO_FILENAME))).exists()) {
            licenseInfoFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenceInfo getServerLicenseInfo(Credentials credentials, DiagnosticLevel diagnosticLevel, ModuleType requiredModule) throws IOException {
        LicenceInfo licenceInfo = null;
        try (ServerRestClient updatedServerRestClient = null;){
            if (credentials.getLicenseId().contains(":")) {
                String[] splits = credentials.getLicenseId().split(":");
                updatedServerRestClient = new ServerRestClient("https://" + splits[0], splits[1], credentials.getLicenseKey(), "", diagnosticLevel);
            } else {
                updatedServerRestClient = new ServerRestClient(credentials.getLicenseId(), credentials.getLicenseKey(), "", diagnosticLevel);
            }
            licenceInfo = updatedServerRestClient.getLicenseInfo();
        }
        if (licenceInfo == null) {
            throw new IOException(this.iu.getString("License.UnsupportedEdition"));
        }
        licenceInfo.assertModuleLicensed(requiredModule);
        return licenceInfo;
    }

    public LicenceInfo getServerLicenseInfo(Credentials credentials, ModuleType requiredModule) throws IOException {
        return this.getServerLicenseInfo(credentials, DiagnosticLevel.ENHANCED, requiredModule);
    }

    public LicenceInfo convertToLicenseInfo(Licence licence) {
        LicenceInfo licenceInfo = null;
        if (licence.licenseInfo != null) {
            Gson gson = new Gson();
            licenceInfo = (LicenceInfo)gson.fromJson(licence.licenseInfo, LicenceInfo.class);
        }
        return licenceInfo;
    }
}

