/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence;

import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.WorkerClass;
import com.nuix.automate.utils.licence.services.Edition;
import org.jetbrains.annotations.NotNull;

public class Module
implements Comparable {
    private ModuleType moduleType;
    private Edition edition;
    private WorkerClass workerClass;

    public Module(ModuleType moduleType, WorkerClass workerClass, Edition edition) {
        this.moduleType = moduleType;
        this.edition = edition;
        this.workerClass = workerClass;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public Edition getEdition() {
        return this.edition;
    }

    public WorkerClass getWorkerClass() {
        return this.workerClass;
    }

    public int compareTo(@NotNull Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return -1;
        }
        Module m = (Module)obj;
        int code = this.moduleType.compareTo(m.moduleType);
        code = code * 10 + this.workerClass.compareTo(m.workerClass);
        code = code * 10 + this.edition.compareTo(m.edition);
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Module m = (Module)obj;
        return this.moduleType == m.moduleType && this.edition == m.edition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + (this.moduleType == null ? 0 : this.moduleType.hashCode());
        result = 31 * result + (this.edition == null ? 0 : this.edition.hashCode());
        return result;
    }

    public String toString() {
        if (this.workerClass.equals((Object)WorkerClass.ANY)) {
            return (Object)((Object)this.moduleType) + " " + (Object)((Object)this.edition);
        }
        return (Object)((Object)this.moduleType) + " " + (Object)((Object)this.workerClass) + " " + (Object)((Object)this.edition);
    }

    public String getCode() {
        return this.moduleType.name().substring(0, 1) + this.workerClass.name().substring(0, 1) + this.edition.name().substring(0, 1);
    }
}

