/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence;

import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Serializer {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Serializer.class);

    public static void serializeLicence(Licence licence, File file) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Licence.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)licence, file);
        LOGGER.info("Saved licence to file " + file.getAbsolutePath());
    }

    public static Licence deserializeLicence(File file) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Licence.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        Licence licence = (Licence)jaxbUnmarshaller.unmarshal(file);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read licence from file " + file.getAbsolutePath());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(licence.toString());
        }
        return licence;
    }

    public static Licence deserializeLicence(String licenceXml) {
        Licence licence = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(licenceXml.getBytes(StandardCharsets.UTF_8));
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Licence.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            licence = (Licence)jaxbUnmarshaller.unmarshal((InputStream)byteArrayInputStream);
            LOGGER.info("Read licence from base64 encoded XML");
            LOGGER.info(licence.toString());
        }
        catch (Exception e) {
            LOGGER.error("Cannot deserialize licence from string: " + licenceXml, e);
        }
        return licence;
    }
}

