/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence.services;

import com.nuix.automate.utils.licence.ModuleType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum Edition {
    COMMUNITY{

        @Override
        public String toLocalizedString() {
            return "Community";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Collections.singletonList(ModuleType.BASELINE));
        }
    }
    ,
    ENTERPRISE{

        @Override
        public String toLocalizedString() {
            return "Enterprise";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return PREMIUM.getImplicitModules();
        }
    }
    ,
    CORPORATE{

        @Override
        public String toLocalizedString() {
            return "Enterprise";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return PREMIUM.getImplicitModules();
        }
    }
    ,
    BUSINESS{

        @Override
        public String toLocalizedString() {
            return "Business";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.BRAINSPACE_REVIEW, ModuleType.DASHBOARD, ModuleType.DISCOVER_REVIEW, ModuleType.RELATIVITY_REVIEW, ModuleType.SCHEDULER_STANDARD, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_LEGAL));
        }
    }
    ,
    PREMIUM{

        @Override
        public String toLocalizedString() {
            return "Premium";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.AZURE_STORAGE, ModuleType.BRAINSPACE_ADVANCED, ModuleType.BRAINSPACE_REVIEW, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.LEGAL_HOLD, ModuleType.PURVIEW_HOLD, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_CONVERSION_STANDARD, ModuleType.RELATIVITY_ADVANCED, ModuleType.RELATIVITY_REVIEW, ModuleType.REMOTE_ENGINES, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.API_ADVANCED, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_LEGAL, ModuleType.WORKFLOW_NATIVE, ModuleType.NATIVE_OCR, ModuleType.AUTOMATE_JSS_API, ModuleType.AUTOMATE_NATIVE_WORKFLOWS, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.MANAGED_DATA_REPOSITORIES));
        }
    }
    ,
    NUIX_DATA_AUTOMATION_PACK{

        @Override
        public String toLocalizedString() {
            return "Nuix Data Automation Pack";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.BRAINSPACE_REVIEW, ModuleType.DASHBOARD, ModuleType.DISCOVER_REVIEW, ModuleType.SCHEDULER_STANDARD, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.IN_PLACE_DATA_REPOSITORIES));
        }
    }
    ,
    NUIX_DATA_HOLD_COLLECT_PROCESSING_PACK{

        @Override
        public String toLocalizedString() {
            return "Nuix Data Hold, Collect & Processing Pack";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.AZURE_STORAGE, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.LEGAL_HOLD, ModuleType.PURVIEW_HOLD, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_CONVERSION_STANDARD, ModuleType.REMOTE_ENGINES, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.API_ADVANCED, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_LEGAL, ModuleType.WORKFLOW_NATIVE, ModuleType.NATIVE_OCR));
        }
    }
    ,
    PATHWAY_NEO_EX_NLP{

        @Override
        public String toLocalizedString() {
            return "Pathway to Neo ex-NLP";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.INVESTIGATE, ModuleType.NEO_MANAGEMENT, ModuleType.SCHEDULER_STANDARD, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE));
        }
    }
    ,
    NEO_DATA_PRIVACY{

        @Override
        public String toLocalizedString() {
            return "Neo Data Privacy";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.AZURE_STORAGE, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.GOOGLE_COLLECTIONS, ModuleType.INVESTIGATE, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_COLLECTIONS_ADVANCED, ModuleType.NEO_MANAGEMENT, ModuleType.NLP, ModuleType.REMOTE_ENGINES, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.MANAGED_DATA_REPOSITORIES, ModuleType.API_ADVANCED, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_LEGAL, ModuleType.WORKFLOW_NATIVE, ModuleType.NATIVE_OCR));
        }
    }
    ,
    NEO_INVESTIGATIONS{

        @Override
        public String toLocalizedString() {
            return "Neo Investigations";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.AZURE_STORAGE, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.GOOGLE_COLLECTIONS, ModuleType.INVESTIGATE, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_COLLECTIONS_ADVANCED, ModuleType.NEO_MANAGEMENT, ModuleType.NLP, ModuleType.REMOTE_ENGINES, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.MANAGED_DATA_REPOSITORIES, ModuleType.API_ADVANCED, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_NATIVE, ModuleType.WORKFLOW_LEGAL, ModuleType.NATIVE_OCR));
        }
    }
    ,
    NEO_LEGAL{

        @Override
        public String toLocalizedString() {
            return "Neo Legal";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.AZURE_STORAGE, ModuleType.BRAINSPACE_ADVANCED, ModuleType.BRAINSPACE_REVIEW, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.GOOGLE_HOLD, ModuleType.GOOGLE_COLLECTIONS, ModuleType.INVESTIGATE, ModuleType.LEGAL_HOLD, ModuleType.PURVIEW_HOLD, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_COLLECTIONS_ADVANCED, ModuleType.NEO_MANAGEMENT, ModuleType.NLP, ModuleType.RELATIVITY_ADVANCED, ModuleType.RELATIVITY_REVIEW, ModuleType.REMOTE_ENGINES, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.MANAGED_DATA_REPOSITORIES, ModuleType.API_ADVANCED, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_LEGAL, ModuleType.WORKFLOW_NATIVE, ModuleType.NATIVE_OCR));
        }
    }
    ,
    NUIX_NEO_FOUNDATION{

        @Override
        public String toLocalizedString() {
            return "Nuix Neo Foundation";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Arrays.asList(ModuleType.API_ADVANCED, ModuleType.AZURE_STORAGE, ModuleType.CLOUD_RESOURCE_POOLS, ModuleType.DASHBOARD, ModuleType.DISCOVER_ADVANCED, ModuleType.DISCOVER_REVIEW, ModuleType.ECC_COLLECTIONS, ModuleType.ELASTICSEARCH, ModuleType.GOOGLE_COLLECTIONS, ModuleType.IN_PLACE_DATA_REPOSITORIES, ModuleType.INVESTIGATE, ModuleType.MANAGED_DATA_REPOSITORIES, ModuleType.NATIVE_OCR, ModuleType.NEO_MANAGEMENT, ModuleType.PURVIEW_COLLECTIONS, ModuleType.PURVIEW_COLLECTIONS_ADVANCED, ModuleType.REMOTE_ENGINES, ModuleType.SCHEDULER_ADVANCED, ModuleType.SCHEDULER_STANDARD, ModuleType.SCHEDULER_UPLOAD, ModuleType.THIRD_PARTY_SERVICES, ModuleType.TRIGGERS_ADVANCED, ModuleType.TRIGGERS_STANDARD, ModuleType.WORKFLOW_ENGINE, ModuleType.WORKFLOW_NATIVE));
        }
    }
    ,
    INTERNAL_TESTING{

        @Override
        public String toLocalizedString() {
            return "Internal Testing";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            Set<ModuleType> modules = NEO_LEGAL.getImplicitModules();
            modules.add(ModuleType.KNOWLEDGE_GRAPH);
            modules.add(ModuleType.GEN_AI);
            modules.add(ModuleType.GEN_AI_EXPERIMENTAL);
            modules.add(ModuleType.PURVIEW_CONVERSION_STANDARD);
            modules.add(ModuleType.VERITONE);
            modules.add(ModuleType.SEMANTIC_TEXT_SEARCH);
            modules.add(ModuleType.SEMANTIC_IMAGE_SEARCH);
            modules.add(ModuleType.SEMANTIC_FACE_VECTORIZATION);
            modules.add(ModuleType.SEMANTIC_TRANSCRIPTION);
            modules.add(ModuleType.AUTOMATE_JSS_API);
            modules.add(ModuleType.AUTOMATE_NATIVE_WORKFLOWS);
            return modules;
        }
    }
    ,
    INTERNAL_UTILIZATION{

        @Override
        public String toLocalizedString() {
            return "Internal Utilization";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            HashSet<ModuleType> modules = new HashSet<ModuleType>();
            modules.add(ModuleType.SCHEDULER_STANDARD);
            modules.add(ModuleType.UTILIZATION_UPLOAD);
            modules.add(ModuleType.DASHBOARD);
            return modules;
        }
    }
    ,
    COLLECTOR{

        @Override
        public String toLocalizedString() {
            return "Collector";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Collections.singletonList(ModuleType.ACONEX));
        }
    }
    ,
    BASELINE{

        @Override
        public String toLocalizedString() {
            return "Baseline";
        }

        @Override
        public Set<ModuleType> getImplicitModules() {
            return new HashSet<ModuleType>(Collections.singletonList(ModuleType.BASELINE));
        }
    };


    public abstract String toLocalizedString();

    public abstract Set<ModuleType> getImplicitModules();
}

