/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.licence.services;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.ModuleNotLicensedException;
import com.nuix.automate.utils.licence.services.Edition;
import com.nuix.automate.utils.licence.services.Environment;
import com.nuix.automate.utils.licence.services.NuixLicense;
import com.nuix.automate.utils.licence.services.ThirdPartyLicense;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LicenceInfo
implements Serializable,
Cloneable {
    private static final transient LoggerWrapper LOGGER = LogManagerUtils.getLogger(LicenceInfo.class);
    private transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private String id;
    private String name;
    private String description;
    private boolean enabled;
    private Long startDate;
    private Long endDate;
    private Long cacheValidityDate;
    private Environment environment;
    @Deprecated
    private Edition edition;
    private Set<Edition> editions;
    private Set<String> modules;
    private Set<NuixLicense> nuixLicenses;
    private Set<ThirdPartyLicense> thirdPartyLicenses;
    private String signature;
    private String signatureV2;
    private String organizationId;
    private String organizationName;
    private Map<String, Object> properties;
    private boolean offline;
    private TreeSet<ModuleType> allModules;

    public LicenceInfo clone() {
        LicenceInfo clonedObject = null;
        try {
            clonedObject = (LicenceInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return clonedObject;
        }
        clonedObject.modules = new TreeSet<String>();
        if (this.modules != null) {
            clonedObject.modules.addAll(this.modules);
        }
        clonedObject.nuixLicenses = new TreeSet<NuixLicense>();
        if (this.nuixLicenses != null) {
            clonedObject.nuixLicenses.addAll(this.nuixLicenses);
        }
        clonedObject.thirdPartyLicenses = new TreeSet<ThirdPartyLicense>();
        if (this.thirdPartyLicenses != null) {
            clonedObject.thirdPartyLicenses.addAll(this.thirdPartyLicenses);
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toValidationString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append("\t");
        stringBuilder.append(this.name);
        stringBuilder.append("\t");
        stringBuilder.append(this.description);
        stringBuilder.append("\t");
        stringBuilder.append(this.enabled);
        stringBuilder.append("\t");
        stringBuilder.append(this.startDate);
        stringBuilder.append("\t");
        stringBuilder.append(this.endDate);
        stringBuilder.append("\t");
        stringBuilder.append(this.cacheValidityDate);
        stringBuilder.append("\t");
        stringBuilder.append(this.environment.name());
        stringBuilder.append("\t");
        if (this.editions != null && this.editions.size() == 1 && this.editions.stream().iterator().next() != this.edition) {
            throw new IllegalStateException("Invalid license");
        }
        stringBuilder.append(this.edition.name());
        stringBuilder.append("\t");
        TreeSet<String> modulesText = new TreeSet<String>();
        if (this.modules != null) {
            for (String string : this.modules) {
                modulesText.add(string);
                stringBuilder.append("\t");
            }
        }
        stringBuilder.append(modulesText);
        TreeSet nuixLicensesText = new TreeSet();
        if (this.nuixLicenses != null) {
            for (NuixLicense nuixLicense : this.nuixLicenses) {
                modulesText.add(nuixLicense.getSysId() + nuixLicense.getWorkerClass().name() + nuixLicense.getWorkerCount());
                stringBuilder.append("\t");
            }
        }
        stringBuilder.append(nuixLicensesText);
        if (this.thirdPartyLicenses != null && this.thirdPartyLicenses.size() > 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (ThirdPartyLicense thirdPartyLicense : this.thirdPartyLicenses) {
                treeSet.add(thirdPartyLicense.getId() + thirdPartyLicense.getThirdPartyProduct() + thirdPartyLicense.getCount());
                treeSet.add("\t");
            }
            stringBuilder.append(treeSet);
        }
        return stringBuilder.toString();
    }

    public String toValidationStringV2() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append("\t");
        stringBuilder.append(this.name);
        stringBuilder.append("\t");
        stringBuilder.append(this.description);
        stringBuilder.append("\t");
        stringBuilder.append(this.enabled);
        stringBuilder.append("\t");
        stringBuilder.append(this.startDate);
        stringBuilder.append("\t");
        stringBuilder.append(this.endDate);
        stringBuilder.append("\t");
        stringBuilder.append(this.environment.name());
        stringBuilder.append("\t");
        if (this.editions != null && this.editions.size() == 1 && this.editions.stream().iterator().next() != this.edition) {
            throw new IllegalStateException("Invalid license");
        }
        ArrayList<String> editionNames = new ArrayList<String>();
        for (Edition edition : this.getEditions()) {
            editionNames.add(edition.name());
        }
        stringBuilder.append(String.join((CharSequence)",", editionNames));
        stringBuilder.append("\t");
        TreeSet<String> modulesText = new TreeSet<String>();
        if (this.modules != null) {
            for (String string : this.modules) {
                modulesText.add(string);
                stringBuilder.append("\t");
            }
        }
        stringBuilder.append(modulesText);
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.nuixLicenses != null) {
            for (NuixLicense nuixLicense : this.nuixLicenses) {
                treeSet.add(nuixLicense.getSysId() + "/" + nuixLicense.getWorkerClass().name() + "/" + nuixLicense.getWorkerCount());
            }
        }
        stringBuilder.append(treeSet);
        TreeSet<String> treeSet2 = new TreeSet<String>();
        if (this.thirdPartyLicenses != null && this.thirdPartyLicenses.size() > 0) {
            for (ThirdPartyLicense thirdPartyLicense : this.thirdPartyLicenses) {
                treeSet2.add(thirdPartyLicense.getId() + "/" + thirdPartyLicense.getThirdPartyProduct() + "/" + thirdPartyLicense.getCount());
            }
        }
        stringBuilder.append(treeSet2);
        return stringBuilder.toString();
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Edition getEdition() {
        return this.edition;
    }

    public void setEdition(Edition edition) {
        this.edition = edition;
    }

    public Set<Edition> getEditions() {
        if (this.editions == null) {
            HashSet<Edition> mainEdition = new HashSet<Edition>();
            mainEdition.add(this.edition);
            return mainEdition;
        }
        return this.editions;
    }

    public void setEditions(Set<Edition> editions) {
        this.editions = editions;
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public void setModules(Set<String> modules) {
        this.modules = modules;
    }

    public Set<NuixLicense> getNuixLicenses() {
        return this.nuixLicenses;
    }

    public void setNuixLicenses(Set<NuixLicense> nuixLicenses) {
        this.nuixLicenses = nuixLicenses;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCacheValidityDate() {
        return this.cacheValidityDate;
    }

    public void setCacheValidityDate(Long cacheValidityDate) {
        this.cacheValidityDate = cacheValidityDate;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public boolean getOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Set<ThirdPartyLicense> getThirdPartyLicenses() {
        return this.thirdPartyLicenses;
    }

    public void setThirdPartyLicenses(Set<ThirdPartyLicense> thirdPartyLicenses) {
        this.thirdPartyLicenses = thirdPartyLicenses;
    }

    public String getSignatureV2() {
        return this.signatureV2;
    }

    public void setSignatureV2(String signatureV2) {
        this.signatureV2 = signatureV2;
    }

    public LicenceInfo cloneLimited() {
        LicenceInfo limited = new LicenceInfo();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        return limited;
    }

    public boolean getModuleLicensed(ModuleType requiredModule) {
        return this.getAllModules().contains((Object)requiredModule);
    }

    public Set<ModuleType> getAllModules() {
        if (this.allModules != null) {
            return this.allModules;
        }
        this.allModules = new TreeSet();
        for (Edition editionI : this.getEditions()) {
            this.allModules.addAll(editionI.getImplicitModules());
        }
        if (this.modules != null) {
            for (String explicitModuleName : this.modules) {
                try {
                    ModuleType explicitModule = ModuleType.getEnum(explicitModuleName);
                    this.allModules.add(explicitModule);
                }
                catch (Exception exception) {}
            }
        }
        this.allModules.remove((Object)ModuleType.SEMANTIC);
        if (this.allModules.contains((Object)ModuleType.SEMANTIC_TEXT_SEARCH) || this.allModules.contains((Object)ModuleType.SEMANTIC_IMAGE_SEARCH) || this.allModules.contains((Object)ModuleType.SEMANTIC_FACE_VECTORIZATION) || this.allModules.contains((Object)ModuleType.SEMANTIC_TRANSCRIPTION)) {
            this.allModules.add(ModuleType.SEMANTIC);
        }
        return this.allModules;
    }

    public void assertModuleLicensed(ModuleType requiredModule) {
        if (!this.getModuleLicensed(requiredModule)) {
            throw new ModuleNotLicensedException(requiredModule);
        }
    }
}

