/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.license;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.licence.services.EventInfo;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.Status;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.consumption.Consumption;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.NotImplementedException;

public class ServerRestClient
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerRestClient.class);
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance("WorkflowText");
    private Client client;
    private static final String licenseInfoUri = "/server/license";
    private static final String licenseConsumptionUri = "/server/license/consumption";
    private static final String utilizationUriPrefix = "/server/utilization/";
    private String baseUri = "https://api.rampiva.services";
    private String licenseId;
    private String licenseKey;
    private String encryptionKey;
    private DiagnosticLevel diagnosticLevel;
    private String clientId;

    public ServerRestClient(String baseUri, String id, String key, String encryptionKey, DiagnosticLevel diagnosticLevel) {
        this(id, key, encryptionKey, diagnosticLevel);
        this.baseUri = baseUri;
    }

    public ServerRestClient(String id, String key, String encryptionKey, DiagnosticLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
        this.encryptionKey = encryptionKey;
        this.licenseId = id;
        this.licenseKey = key;
        this.clientId = UidUtils.getRandom();
        this.client = WsRsRestClientFactory.getClient(this.clientId);
    }

    public void setDiagnosticLevel(DiagnosticLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel;
    }

    public void setEncryptionKey(String encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String method, RequestType requestData, GenericType<ResponseType> entityType) throws IOException {
        Response response = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(method + " " + url);
        }
        try {
            Object responseData;
            String stringResponse;
            if (this.licenseKey == null || this.licenseKey.length() == 0) {
                throw new IOException("License key must be re-entered");
            }
            WebTarget webTarget = this.client.target(this.baseUri + url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("ApiKey " + this.licenseId + ":" + this.licenseKey));
            switch (method) {
                case "POST": {
                    response = invocationBuilder.post(Entity.entity((Object)SerializationUtils.gsonWithoutNulls.toJson(requestData), (String)"application/json"));
                    break;
                }
                case "PUT": {
                    response = invocationBuilder.put(Entity.entity((Object)SerializationUtils.gsonWithoutNulls.toJson(requestData), (String)"application/json"));
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API with body");
                }
            }
            if (response.getStatus() == 403) {
                throw new IOException(this.iu.getString("Licence.Format.InvalidIdOrKey"));
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                response.bufferEntity();
                stringResponse = (String)response.readEntity(String.class);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            stringResponse = (String)response.readEntity(String.class);
            Object t = responseData = SerializationUtils.fromJson(stringResponse, entityType.getRawType());
            return (ResponseType)t;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query License Services API, " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public <ResponseType, RequestType> ResponseType callApi(String url, String method, GenericType<ResponseType> entityType) throws IOException {
        Response response = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(method + " " + url);
        }
        try {
            Object responseData;
            String stringResponse;
            if (this.licenseKey == null || this.licenseKey.length() == 0) {
                throw new IOException("License key must be re-entered");
            }
            WebTarget webTarget = this.client.target(this.baseUri + url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("ApiKey " + this.licenseId + ":" + this.licenseKey));
            switch (method) {
                case "GET": {
                    response = invocationBuilder.get();
                    break;
                }
                case "DELETE": {
                    response = invocationBuilder.delete();
                    break;
                }
                default: {
                    throw new NotImplementedException("Method " + method + " not implemented in server API without body");
                }
            }
            if (response.getStatus() == 403) {
                throw new IOException(this.iu.getString("Licence.Format.InvalidIdOrKey"));
            }
            if (response.getStatus() != 200 && response.getStatus() != 201 && response.getStatus() != 202) {
                response.bufferEntity();
                stringResponse = (String)response.readEntity(String.class);
                LOGGER.error(this.baseUri + "/" + url + " responded with HTTP/" + response.getStatus() + " " + stringResponse);
                throw new IOException("HTTP/" + response.getStatus() + " " + stringResponse);
            }
            stringResponse = (String)response.readEntity(String.class);
            Object t = responseData = SerializationUtils.fromJson(stringResponse, entityType.getRawType());
            return (ResponseType)t;
        }
        catch (Exception e) {
            LOGGER.error("Cannot query License Services API", e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public LicenceInfo getLicenseInfo() throws IOException {
        LicenceInfo response = this.callApi(licenseInfoUri, "GET", new GenericType<LicenceInfo>(){});
        return response;
    }

    public Status trackEvent(EventInfo event) throws IOException {
        Status response = this.callApi(licenseInfoUri, "POST", event, new GenericType<Status>(){});
        return response;
    }

    public Status trackConsumption(Consumption consumption) throws IOException {
        Status response = this.callApi(licenseConsumptionUri, "POST", consumption, new GenericType<Status>(){});
        return response;
    }

    public Status trackUtilizationRecords(UtilizationRecords utilizationRecords) throws IOException {
        UtilizationRecords encryptedUtilizationRecords = null;
        if (this.diagnosticLevel.equals((Object)DiagnosticLevel.REQUIRED)) {
            Set<Session> sessions;
            encryptedUtilizationRecords = new UtilizationRecords();
            Set<Transfer> transfers = utilizationRecords.getTransfers();
            if (transfers != null && transfers.size() > 0) {
                encryptedUtilizationRecords.setTransfers(transfers);
            }
            if ((sessions = utilizationRecords.getSessions()) != null && sessions.size() > 0) {
                encryptedUtilizationRecords.setSessions(sessions);
            }
            encryptedUtilizationRecords.encryptSensitiveProperties(this.encryptionKey, this.diagnosticLevel, false);
        } else if (this.diagnosticLevel.equals((Object)DiagnosticLevel.ENHANCED) || this.diagnosticLevel.equals((Object)DiagnosticLevel.OPTIONAL)) {
            encryptedUtilizationRecords = utilizationRecords.clone();
            encryptedUtilizationRecords.encryptSensitiveProperties(this.encryptionKey, this.diagnosticLevel, false);
        }
        if (encryptedUtilizationRecords != null) {
            Status response = this.callApi(utilizationUriPrefix, "POST", encryptedUtilizationRecords, new GenericType<Status>(){});
            return response;
        }
        return new Status();
    }

    @Override
    public void close() throws IOException {
        WsRsRestClientFactory.remove(this.clientId);
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                LOGGER.error("Cannot close client", e);
            }
        }
    }
}

