/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import io.dropwizard.logging.DropwizardLayout;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.TimeZone;

public class CentralizedLogInterceptor<E>
extends AppenderBase<E> {
    private LogHandler logHandler = LogHandler.getInstance();
    private Layout<E> layout;

    public void start() {
        super.start();
        this.layout = this.buildLayout();
        this.layout.start();
    }

    public void stop() {
        super.stop();
        this.layout.stop();
    }

    private Layout<E> buildLayout() {
        TimeZone zone = TimeZone.getTimeZone(ZoneId.systemDefault());
        DropwizardLayout layout = new DropwizardLayout((LoggerContext)this.getContext(), zone);
        layout.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} [%thread] %-5level %logger - %msg%n");
        return layout;
    }

    protected void append(E e) {
        String message = this.layout.doLayout(e);
        LogEventModel model = new LogEventModel(((ILoggingEvent)e).getTimeStamp(), message.getBytes(StandardCharsets.UTF_8));
        this.logHandler.fillAndAddLogEvent(model);
    }
}

