/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.logging;

import com.nuix.automate.utils.general.TimestampedString;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CircularBufferLog {
    private int maxLines;
    private final List<TimestampedString> logLines;

    public CircularBufferLog() {
        this(30);
    }

    public CircularBufferLog(int maxLines) {
        this.maxLines = maxLines;
        this.logLines = new ArrayList<TimestampedString>();
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(0, maxLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(String logLine) {
        CircularBufferLog circularBufferLog = this;
        synchronized (circularBufferLog) {
            this.logLines.add(new TimestampedString(new DateTime(DateTimeZone.UTC).getMillis(), logLine));
            this.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<TimestampedString> logLines) {
        CircularBufferLog circularBufferLog = this;
        synchronized (circularBufferLog) {
            this.logLines.addAll(logLines);
            this.trim();
        }
    }

    public String getLastLogLine() {
        if (!this.logLines.isEmpty()) {
            return this.logLines.get(this.logLines.size() - 1).getString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLastLogLine() {
        CircularBufferLog circularBufferLog = this;
        synchronized (circularBufferLog) {
            int size = this.logLines.size();
            if (size > 0) {
                this.logLines.remove(size - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CircularBufferLog circularBufferLog = this;
        synchronized (circularBufferLog) {
            this.logLines.clear();
        }
    }

    private void trim() {
        while (this.logLines.size() > this.maxLines) {
            this.logLines.remove(0);
        }
    }

    public List<TimestampedString> getLog() {
        return this.logLines;
    }
}

